﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.NintendoSdkVsExtension.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.Models
{
    /// <summary>
    /// 「NintendoSDK のパスを設定する」ためのデータ構造およびロジック
    /// </summary>
    public class ChooseSdkRootDialogModel : Common.BindableBase
    {
        private SdkRootKind _sdkRootKind = SdkRootKind.DirectProperty;
        private string _directPropertyValue = string.Empty;
        private string _ndiEnvironmentNameValue = string.Empty;

        public SdkRootKind Kind
        {
            get { return this._sdkRootKind; }
            set
            {
                if (SetProperty(ref this._sdkRootKind, value))
                {
                    RaiseSdkRootChanged();
                }
            }
        }

        public string DirectPropertyValue
        {
            get { return this._directPropertyValue; }
            set
            {
                if (SetProperty(ref this._directPropertyValue, value))
                {
                    RaisePropretyChanged(nameof(this.EvaluatedSdkRootPath));
                    RaiseSdkRootChanged();
                }
            }
        }

        public string NdiEnvironmentNameValue
        {
            get { return this._ndiEnvironmentNameValue; }
            set
            {
                if (SetProperty(ref this._ndiEnvironmentNameValue, value))
                {
                    RaiseSdkRootChanged();
                }
            }
        }

        public string EvaluatedSdkRootPath => MsBuildUtil.EvaluateConfigurationProperty(ToSdkRoot().ToEvaluatedPath());
        public bool IsSdkRootValid => SdkInformation.IsValidSdkRoot(ToSdkRoot());
        // TORIAEZU:
        public string ErrorMessage => ErrorMessageUtil.InvalidSdkRoot(ToSdkRoot().ToEvaluatedPath());

        public ChooseSdkRootDialogModel(SdkRoot sdkRoot)
        {
            this._sdkRootKind = sdkRoot.Kind;
            switch (sdkRoot.Kind)
            {
                case SdkRootKind.DirectProperty:
                    this._directPropertyValue = sdkRoot.Value;
                    break;
                case SdkRootKind.NdiEnvironmentName:
                    this._ndiEnvironmentNameValue = sdkRoot.Value;
                    break;
                default:
                    throw new ArgumentException();
            }
        }

        public SdkRoot ToSdkRoot()
        {
            switch (this._sdkRootKind)
            {
                case SdkRootKind.DirectProperty:
                    return new SdkRoot(this._sdkRootKind, this._directPropertyValue);
                case SdkRootKind.NdiEnvironmentName:
                    return new SdkRoot(this._sdkRootKind, this._ndiEnvironmentNameValue);
                default:
                    throw new ArgumentException();
            }
        }

        private void RaiseSdkRootChanged()
        {
            RaisePropretyChanged(nameof(this.IsSdkRootValid));
            RaisePropretyChanged(nameof(this.ErrorMessage));
            RaisePropretyChanged(nameof(this.EvaluatedSdkRootPath));
        }
    }
}
