﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.Base
{
    public class Cache<TKey, TValue>
    {
        private readonly Dictionary<TKey, TValue> _cache = new Dictionary<TKey, TValue>();
        private readonly Func<TKey, TValue> _valueCreator;  // may throw exception

        public Cache(Func<TKey, TValue> valueCreator)
        {
            this._valueCreator = valueCreator;
        }

        public TValue GetValue(TKey key)
        {
            lock (_cache)
            {
                TValue value;
                if (_cache.TryGetValue(key, out value))
                {
                    return value;
                }
                else
                {
                    value = _valueCreator(key);
                    _cache.Add(key, value);
                    return value;
                }
            }
        }

        public void Clear()
        {
            lock (_cache)
            {
                _cache.Clear();
            }
        }
    }
}
