﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "./../../../../Programs/Eris/Sources/Libraries/ngc/succinct/ngc_OutputStream.h"

namespace nn { namespace ngc { namespace detail {

struct FileOutputStreamSettings
{
    void* buf;
    size_t bufferSize;

public:
    constexpr FileOutputStreamSettings() NN_NOEXCEPT : buf(NULL), bufferSize(4096) {}
    constexpr FileOutputStreamSettings(void* p, size_t size) NN_NOEXCEPT
        : buf(p),
          bufferSize(size) {}
};

class FileOutputStream final : public OutputStream
{
public:
    FileOutputStream() NN_NOEXCEPT : m_Fd(NLIB_FD_INVALID),
                                     m_Buf(NULL),
                                     m_BufSize(0),
                                     m_IsInternalBuf(false) {}
    virtual ~FileOutputStream() NN_NOEXCEPT final override;
    errno_t Init() NN_NOEXCEPT
    {
        constexpr FileOutputStreamSettings settings;
        return this->Init(settings);
    }
    errno_t Init(const FileOutputStreamSettings& settings) NN_NOEXCEPT;
    errno_t Open(const char* filename, int flags, int mode) NN_NOEXCEPT;
    errno_t Open(const char* filename) NN_NOEXCEPT
    {
        return Open(filename, NLIB_FD_O_WRONLY | NLIB_FD_O_CREAT | NLIB_FD_O_TRUNC, 0644);
    }
    errno_t Open(const char* filename, int flags) NN_NOEXCEPT
    {
        return Open(filename, flags, 0644);
    }
    errno_t Open(const wchar_t* filename,
                                   int flags, int mode) NN_NOEXCEPT NLIB_NONNULL;
    errno_t Open(const wchar_t* filename, int flags) NN_NOEXCEPT
    {
        return Open(filename, flags, 0644);
    }
    errno_t Open(const wchar_t* filename) NN_NOEXCEPT
    {
        return Open(filename, NLIB_FD_O_WRONLY | NLIB_FD_O_CREAT | NLIB_FD_O_TRUNC, 0644);
    }
    errno_t FdOpen(nlib_fd fd) NN_NOEXCEPT;
    nlib_fd GetFd() const NN_NOEXCEPT
    {
        return m_Fd;
    }

private:
    virtual bool PushBuffer_(const void* p, size_t nbytes,
                             bool do_flush) NN_NOEXCEPT override;
    virtual bool Close_() NN_NOEXCEPT override;
    virtual bool WriteGather_(const FdIoVec* iov, int iovcnt) NN_NOEXCEPT override;

private:
    nlib_fd m_Fd;
    unsigned char* m_Buf;
    size_t m_BufSize;
    bool m_IsInternalBuf;

    FileOutputStream(const FileOutputStream&) = delete;
    void operator=(const FileOutputStream&) = delete;
};

}}} // nn::ngc::detail
