﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nlib/Config.h>

#include "NgWordConverter.h"

namespace {

const std::string Version = "1.0.0";

// errno_t の詳細を表示
void DispError(errno_t e)
{
    switch (e)
    {
    case 0:
        nlib_printf("Success\n");
        break;
    case EINVAL:
        nlib_printf("ERROR: EINVAL\n");
        break;
    case ENOTSUP:
        nlib_printf("ERROR: ENOTSUP\n");
        break;
    case ENOMEM:
        nlib_printf("ERROR: Out of memory (ENOMEM)\n");
        break;
    case ELOOP:
        nlib_printf("ERROR: ELOOP\n");
        break;
    case EBADF:
        nlib_printf("ERROR: EBADF\n");
        break;
    case EIO:
        nlib_printf("ERROR: File I/O error (EIO)\n");
        break;
    case ENOENT:
        nlib_printf("ERROR: ENOENT\n");
        break;
    case EISDIR:
        nlib_printf("ERROR: EISDIR\n");
        break;
    case EPERM:
        nlib_printf("ERROR: Permission denied (EPERM)\n");
        break;
    default:
        nlib_printf("ERROR:\n");
        break;
    }

    nlib_printf("An error occured.\n Conversion is Stoped.\n");
}

// オプションの読み込み
// 処理を終了させるオプションだったら false を返す
// 対応オプション：
//  -h, --help  ヘルプの表示
bool ReadOption(int argc, char* argv[], NgWordConverter* pConverter)
{
    int option = 0;
    for (int i = 1; i < argc; ++i)  // 0 にはファイル名が入るので飛ばす
    {
        std::string argStr = argv[i];
        if (argStr == "-h" || argStr == "--help")
        {
            nlib_printf("-----------------------------------------------------------\n");
            nlib_printf("Option\n");
            nlib_printf("-v, --version            : Display version\n");
            nlib_printf("-d, --debug              : Output debug intermediates texts\n");
            nlib_printf("-p [path], --path [path] : Set siglo root FULL path\n");
            nlib_printf("-----------------------------------------------------------\n");
            nlib_printf("You can use this program without any arguments.\n");
            nlib_printf("Please execute this program with no option.\n");
            nlib_printf("Read Directory:   Programs\\Iris\\Resources\\NgWord\n");
            nlib_printf("Output Directory: Programs\\Iris\\Resources\\NgWord\n");
            nlib_printf("CAUTION: If you move this program to outsize of\n");
            nlib_printf("         $SIGLO_ROOT\\Integrate\\Outputs\\AnyCPU\\Tools\\NgWordConverter\\NgWordConverter\\Release,\n");
            nlib_printf("         it may will not work properly.\n");
            nlib_printf("         You should set proper $SIGLO_ROOT path by using -p option.\n");
            return false;
        }
        else if (argStr == "-v" || argStr == "--version")
        {
            nlib_printf("NgWordConverter Version %s\n", Version.c_str());
            return false;
        }
        else if (argStr == "-d" || argStr == "--debug")
        {
            option |= NgWordConverter::ExportAcBinOption_DebugOutputs;
            pConverter->SetOption(option);
        }
        else if (argStr == "-p" || argStr == "--path")
        {
            ++i;
            argStr = argv[i];
            pConverter->SetRootPath(argStr);
        }
        else
        {
            nlib_printf("Invalid arguments. Please see \"-h\" help.\n");
            return false;
        }
    }
    return true;
}

}   // unnamed namespace

int main(int argc, char* argv[])
{
    nlib_printf("\n===============\n");
    nlib_printf("NgWordConverter");
    nlib_printf("\n===============\n");

    NgWordConverter converter;

    if (!ReadOption(argc, argv, &converter))
    {
        return 0;
    }

    nlib_printf("Start conversion.\n");
    nlib_printf("-----------------\n");

    auto result = converter.CreateAcBinary();
    if (result != 0)
    {
        DispError(result);
        nlib_printf("[FAIL]\nPush any key to finish.\n");
        getchar();
        return -1;
    }

    nlib_printf("-----------------\n");
    nlib_printf("Finish convertion.\n");
    nlib_printf("[SUCCESS]\nPush any key to finish.\n");
    getchar();

    return 0;
}
