﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;

namespace MakeUnpublishableApiList.ApiListData
{
    [System.Xml.Serialization.XmlRoot("api", IsNullable = false)]
    public class ApiModel
    {
        [System.Xml.Serialization.XmlElement("id")]
        public string Id { get; set; }
        [System.Xml.Serialization.XmlElement("title")]
        public string Title { get; set; }
        [System.Xml.Serialization.XmlElement("xpath")]
        public string Xpath { get; set; }
        [System.Xml.Serialization.XmlElement("memo")]
        public string Memo { get; set; }
        [System.Xml.Serialization.XmlElement("source")]
        public string ErrorDisplayAllowed { get; set; }
        [System.Xml.Serialization.XmlElement("display_name")]
        public string DisplayName { get; set; }
    }

    [System.Xml.Serialization.XmlRoot("api-list", IsNullable = false)]
    public class ApiListModel
    {
        [System.Xml.Serialization.XmlElement("api")]
        public List<ApiModel> ApiModel { get; set; }
    }
}
