﻿using System;
using System.IO;
using System.Xml;

namespace IFFRefGen.Src
{
    // スキーマ関連オブジェクトの抽象クラス
    public abstract class XsdItem
    {
        public XsdItem(XmlElement element, string filePath)
        {
            _element = element;
            _filePath = filePath;
            _fileName = Path.GetFileName(filePath);
            _name = element.GetAttribute("name");
            if (_name == string.Empty) { Error("name 属性が見つかりません"); }
        }

        // プリミティブ型用のコンストラクタ
        public XsdItem(string name)
        {
            _element = null;
            _filePath = string.Empty;
            _fileName = string.Empty;
            _name = name;
            // プリミティブは初期化を必要としない
            _initialized = true;
        }

        public virtual void Initialize()
        {
            // XsdItem.Initialize() が複数回呼ばれないようにするのはサブクラスの義務
            if (_initialized) { Error("スキーマ要素が複数回初期化されました"); }
            _initialized = true;
        }

        // 使用フラグを立てる
        public virtual void Use() { _used = true; }

        public override string ToString() { return this.Name; }

        public void Error(string message)
        {
            throw new Exception(string.Format("{0} {1}", message, this));
        }

        public XmlElement Element { get { return _element; } }
        public string FilePath { get { return _filePath; } }
        public string FileName { get { return _fileName; } }
        public string Name { get { return _name; } }
        public bool IsInitialized { get { return _initialized; } }
        public bool IsUsed { get { return _used; } }

        private readonly XmlElement _element;
        private readonly string _filePath;
        private readonly string _fileName;
        private readonly string _name;
        private bool _initialized;
        private bool _used;
    }
}
