﻿using System;
using System.Diagnostics;
using System.Xml;

namespace IFFRefGen.Src
{
    // ComplexType の内容からの要素参照 element ref
    public class XsdContentReference : XsdContent
    {
        // コンストラクタ
        public XsdContentReference(XmlElement element, XsdComplexType containerType)
            : base(element, containerType) { }

        // 初期化
        public override void Initialize()
        {
            this.ReferenceName = this.Element.GetAttribute("ref");
            if (this.ReferenceName == string.Empty)
            {
                this.ContainerType.Error("element に ref 属性が見つかりません");
            }

            // Element の探索
            this.Reference = GXsd.FindElement(this.ReferenceName);
            if (this.Reference == null)
            {
                this.ContainerType.Error(
                    "element が参照する element が見つかりません " + this.ReferenceName);
            }
            this.Reference.Initialize();

            this.MaxOccurs = GetOccuresInt(this.Element.GetAttribute("maxOccurs"));
            this.MinOccurs = GetOccuresInt(this.Element.GetAttribute("minOccurs"));
            Debug.Assert(this.MinOccurs != -1, "Assertion (toDo)");
        }

        // 列挙数の取得
        private int GetOccuresInt(string occures)
        {
            switch (occures)
            {
                case "":
                    return 1;
                case "unbounded":
                    return -1;
                default:
                    return int.Parse(occures);
            }
        }

        // 使用フラグを立てる
        public override void Use() { this.Reference.Use(); }

        // 参照名
        public string ReferenceName { get; private set; }
        // 参照要素
        public XsdElement Reference { get; private set; }

        // "unbounded" なら -1
        public int MaxOccurs { get; private set; }
        public int MinOccurs { get; private set; }
    }
}
