﻿using System.Collections.Generic;
using System.Xml;

namespace IFFRefGen.Src
{
    // choice の ComplexType 内容
    public class XsdContentChoice : XsdContent
    {
        // コンストラクタ
        public XsdContentChoice(XmlElement element, XsdComplexType containerType)
            : base(element, containerType) { }

        // 初期化
        public override void Initialize()
        {
            foreach (XmlNode node in this.Element.ChildNodes)
            {
                if (node.NodeType == XmlNodeType.Comment) { continue; }
                XmlElement element = (XmlElement)node;

                XsdContent content = null;
                switch (element.LocalName)
                {
                    case "sequence":
                        content = new XsdContentSequence(element, this.ContainerType);
                        break;
                    case "element":
                        content = new XsdContentReference(element, this.ContainerType);
                        break;
                    case "any":
                        content = new XsdContentAny(element, this.ContainerType);
                        break;
                    default:
                        this.ContainerType.Error("非サポートの要素です " + element.LocalName);
                        break;
                }
                if (content == null) { this.ContainerType.Error("choice に内容がありません"); }
                content.Initialize();
                this.Contents.Add(content);
            }
        }

        // 使用フラグを立てる
        public override void Use()
        {
            foreach (XsdContent content in this.Contents) { content.Use(); }
        }

        // XsdContentSequence、XsdContentReference のリスト
        public List<XsdContent> Contents { get { return _contents; } }
        private readonly List<XsdContent> _contents = new List<XsdContent>();
    }
}
