﻿using System;
using System.Diagnostics;
using System.Xml;

namespace IFFRefGen.Src
{
    // 何でも格納できる ComplexType の内容
    public class XsdContentAny : XsdContent
    {
        // コンストラクタ
        public XsdContentAny(XmlElement element, XsdComplexType containerType)
            : base(element, containerType) { }

        // 初期化
        public override void Initialize()
        {
            this.MaxOccurs = GetOccuresInt(this.Element.GetAttribute("maxOccurs"));
            this.MinOccurs = GetOccuresInt(this.Element.GetAttribute("minOccurs"));
            Debug.Assert(this.MinOccurs != -1, "Assertion (toDo)");
        }

        // 列挙数の取得
        private int GetOccuresInt(string occures)
        {
            switch (occures)
            {
                case "":
                    return 1;
                case "unbounded":
                    return -1;
                default:
                    return int.Parse(occures);
            }
        }

        // "unbounded" なら -1
        public int MaxOccurs { get; private set; }
        public int MinOccurs { get; private set; }
    }
}
