﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace IFFRefGen.Src
{
    // サンプルデータ
    public class SmplData
    {
        // プリサンプル行数
        private readonly int PreLineNumber = 4;
        // デフォルトのサンプル行数
        private readonly int DefaultLineNumber = 20;

        // コンストラクタ
        public SmplData(string filePath)
        {
            this.FilePath = filePath;
            this.Lines = File.ReadAllLines(this.FilePath, Encoding.UTF8);
        }

        // 初期化
        public void Initialize()
        {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.Lines.Length; i++)
            {
                // タブをスペースに置換
                string line = this.Lines[i];
                while (true)
                {
                    int tabIndex = line.IndexOf('\t');
                    if (tabIndex == -1) { break; }

                    string space = string.Empty;
                    for (int j = 0; j < tabIndex % 4; j++) { space += " "; }
                    if (space.Length == 0) { space = "    "; }

                    line = line.Remove(tabIndex, 1);
                    line = line.Insert(tabIndex, space);
                }

                // 行番号追加
                string lineNumberStr = i.ToString();
                for (int j = lineNumberStr.Length; j < 4; j++)
                {
                    builder.Append(' ');
                }
                builder.AppendFormat("{0}│{1}", i, line);

                this.Lines[i] = builder.ToString();
                builder.Clear();
            }
        }

        // 全データの取得
        public string GetLines()
        {
            StringBuilder builder = new StringBuilder();
            foreach (string line in this.Lines)
            {
                builder.AppendLine(line);
            }
            return builder.ToString();
        }

        // 要素サンプルの取得
        public string[] GetElementSample(string elementName, int lineNumber)
        {
            string[] result = new string[2];

            // サンプル内の要素探索
            string element0 = "<" + elementName + ">";
            string element1 = "<" + elementName + " ";
            string element2 = "<" + elementName;
            int elementIndex = -1;

            for (int i = 0; i < this.Lines.Length; i++)
            {
                string line = this.Lines[i];
                if ((line.IndexOf(element0) != -1) ||
                    (line.IndexOf(element1) != -1) ||
                    (line.EndsWith(element2)))
                {
                    elementIndex = i;
                    break;
                }
            }

            if (elementIndex == -1)
            {
                throw new Exception(string.Format(
                    "サンプルが見つかりません。{0} <{1}>",
                    this.FileName, elementName));
            }

            // プレサンプル文字列の構築
            StringBuilder builder = new StringBuilder();

            if ((elementIndex - this.PreLineNumber) > 0)
            {
                builder.AppendLine("      ...");
            }
            for (int i = 0; i < this.PreLineNumber; i++)
            {
                int index = elementIndex - this.PreLineNumber + i;
                if (index < 0) { continue; }
                builder.AppendLine(this.Lines[index]);
            }
            result[0] = builder.ToString();
            builder.Clear();

            // サンプル文字列の構築
            if (lineNumber == 0) { lineNumber = this.DefaultLineNumber; }
            for (int i = 0; i < lineNumber; i++)
            {
                int index = elementIndex + i;
                if (index == this.Lines.Length) { break; }
                builder.AppendLine(this.Lines[index]);
                if (i == (lineNumber - 1)) { builder.AppendLine("      ..."); }
            }
            result[1] = builder.ToString();
            return result;
        }

        public string FilePath { get; private set; }
        public string FileName { get { return Path.GetFileName(this.FilePath); } }
        public string[] Lines { get; private set; }
    }
}
