﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.IO;

namespace IFFRefGen.Src
{
    // サンプル関連のグローバルクラス
    public static class GSmpl
    {
        // サンプルデータのコピーパスフォーマット文字列
        private const string SampleDataCopyPathFormat = "html/sample/data/{0}";

        // 初期化
        public static void Initialize()
        {
            foreach (string filePath in Directory.EnumerateFiles(
                GApp.Config.SampleFolder, "*.*", SearchOption.TopDirectoryOnly))
            {
                SmplData sampleData = new SmplData(filePath);
                sampleData.Initialize();
                GSmpl.Samples.Add(sampleData.FileName, sampleData);
            }
        }

        // 生成
        public static void Generate()
        {
            foreach (string filePath in Directory.EnumerateFiles(
                GApp.Config.SampleFolder, "*.*", SearchOption.TopDirectoryOnly))
            {
                string dstPath = System.IO.Path.Combine(
                    GApp.Config.HtmlOutputConfig.OutputFolder, string.Format(GSmpl.SampleDataCopyPathFormat, Path.GetFileName(filePath)));
                string dstDir = System.IO.Path.GetDirectoryName(dstPath);
                if (!System.IO.Directory.Exists(dstDir))
                {
                    System.IO.Directory.CreateDirectory(dstDir);
                }

                File.Copy(filePath, dstPath);
            }
        }

        // サンプルの検索
        public static SmplData FindSample(string fileName)
        {
            if (!GSmpl.Samples.ContainsKey(fileName)) { return null; }
            return GSmpl.Samples[fileName];
        }

        // サンプル配列の取得
        public static SmplData[] GetSamples()
        {
            return GSmpl.Samples.Values.ToArray<SmplData>();
        }

        // sample
        private static readonly Dictionary<string, SmplData> Samples =
            new Dictionary<string, SmplData>();
    }
}
