﻿using System.Collections.Generic;
using System.IO;
using System.Xml;
using System.Text;
using System.Threading;

namespace IFFRefGen.Src
{
    // HTML 出力関連のグローバルクラス
    public static class GHtml
    {
        #region 初期化
        // 初期化
        public static void Initialize()
        {
            foreach (ReferenceRootConfig config in GApp.Config.ReferenceRootConfigs)
            {
                // リファレンス目次の初期化
                HtmlReferenceContent refContent = new HtmlReferenceContent(
                    config.Title, config.RootElementName);
                refContent.Initialize();
                GHtml.ReferenceContents.Add(refContent);
            }

            foreach (XsdElement xsdElement in GXsd.Elements)
            {
                HtmlElement htmlElement = new HtmlElement(xsdElement);
                htmlElement.Initialize();
                GHtml.HtmlElements.Add(htmlElement);
            }

            // 要素リストの初期化
            GHtml.ElementList.Initialize();

            // 属性リストの初期化
            GHtml.AttributeList.Initialize();

            // サンプルの初期化
            foreach (SmplData sampleData in GSmpl.GetSamples())
            {
                HtmlSample htmlSample = new HtmlSample(sampleData);
                htmlSample.Initialize();
                GHtml.HtmlSamples.Add(htmlSample);
            }

            // サンプルリストの初期化
            GHtml.SampleList.Initialize();
        }
        #endregion

        #region 生成
        // 生成
        public static void Generate()
        {
            // 出力フォルダの削除と生成
            string outputFolder = GApp.Config.HtmlOutputConfig.OutputFolder;
            if (Directory.Exists(outputFolder))
            {
                Directory.Delete(outputFolder, true);
            }

            Thread.Sleep(100); // 作成したディレクトリが削除されてるっぽい不具合の仮対処
            Directory.CreateDirectory(outputFolder);

            // コピーフォルダをコピー、ダミーページを上書きするために先にコピーする
            GHtml.Copy(GApp.Config.HtmlOutputConfig.TemplatePageFolder, outputFolder);

            // リファレンス目次の生成
            foreach (HtmlReferenceContent refContent in GHtml.ReferenceContents)
            {
                refContent.Generate();
            }

            // 要素の生成
            foreach (HtmlElement htmlElement in GHtml.HtmlElements)
            {
                htmlElement.Generate();
            }

            // 要素リストの生成
            GHtml.ElementList.Generate();

            // 属性リストの生成
            GHtml.AttributeList.Generate();

            // サンプルの生成
            foreach (HtmlSample htmlSample in GHtml.HtmlSamples)
            {
                htmlSample.Generate();
            }

            // サンプルリストの生成
            GHtml.SampleList.Generate();
        }

        // コピーフォルダのコピー
        private static void Copy(string source, string destination)
        {
            foreach (string srcFile in Directory.GetFiles(source))
            {
                File.Copy(srcFile, System.IO.Path.Combine(destination, Path.GetFileName(srcFile)));
                //Debug.WriteLine(srcFile);
            }

            foreach (string srcFolder in Directory.GetDirectories(source))
            {
                if (srcFolder.EndsWith(".svn"))
                {
                    continue;
                }

                string dstFolder = System.IO.Path.Combine(destination, Path.GetFileName(srcFolder));
                Directory.CreateDirectory(dstFolder);
                GHtml.Copy(srcFolder, dstFolder);
            }
        }

        // 保存
        public static void Save(XmlDocument document, string filePath)
        {
            string dir = System.IO.Path.GetDirectoryName(filePath);
            if (!System.IO.Directory.Exists(dir))
            {
                System.IO.Directory.CreateDirectory(dir);
            }

            // DOCTYPE を XmlDocument.Load() で読み込むと、不具合でごみ（.dtd"[]>）が付くので、
            // 自前で DOCTYPE を追加する
            document.XmlResolver = null;
            XmlDocumentType docType = document.CreateDocumentType(
                "html", "-//W3C//DTD XHTML 1.0 Transitional//EN",
                "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd",
                null);
            // document.FirstChild は XML 宣言なので、その次に
            document.InsertAfter(docType, document.FirstChild);

            XmlWriterSettings settings = new XmlWriterSettings();
            settings.Indent = true;
            settings.IndentChars = "\t";
            settings.Encoding = Encoding.GetEncoding("utf-8");
            settings.OmitXmlDeclaration = true;
            using (XmlWriter writer = XmlWriter.Create(filePath, settings))
            {
                document.Save(writer);
            }
        }
        #endregion

        #region ユーティリティ
        // 要素へのリンク
        public static string LinkElement(string source, string relativePath = "./")
        {
            string result = source;
            int ltIndex = 0, gtIndex;
            while (true)
            {
                ltIndex = result.IndexOf("&lt;", ltIndex);
                if (ltIndex == -1) { break; }
                gtIndex = result.IndexOf("&gt;", ltIndex);
                if (gtIndex == -1) { break; }

                string elementName = result.Substring(
                    ltIndex + 4, gtIndex - ltIndex - 4);
                if (GXsd.FindElement(elementName) == null) { break; }

                int length = result.Length;
                result = result.Insert(gtIndex + 4, "</a>");
                string link = string.Format(
                    "<a href=\"{0}{1}.html\">", relativePath, elementName);
                result = result.Insert(ltIndex, link);
                ltIndex = gtIndex + result.Length - length + 4;
            }
            return result;
        }
        #endregion

        // リファレンス目次
        public static readonly List<HtmlReferenceContent> ReferenceContents =
            new List<HtmlReferenceContent>();
        // 要素
        public static readonly List<HtmlElement> HtmlElements =
            new List<HtmlElement>();
        // 要素リスト
        public static readonly HtmlElementList ElementList = new HtmlElementList();
        // 属性リスト
        public static readonly HtmlAttributeList AttributeList = new HtmlAttributeList();
        // サンプル
        public static readonly List<HtmlSample> HtmlSamples = new List<HtmlSample>();
        // サンプルリスト
        public static readonly HtmlSampleList SampleList = new HtmlSampleList();
    }
}
