﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Reflection;

namespace GllSourceGenerator
{
    // このツールで必要なものだけ

    class OptionAttribute : Attribute
    {
        public string LongName { get; set; }

        public string Description { get; set; }

        public OptionAttribute( string longName, string description )
        {
            LongName = longName;
            Description = description;
        }
    }

    class CommandLineParser
    {
        public static bool Parse<T>( T options, string[] args )
        {
            var type = options.GetType();
            var properties = type.GetProperties();
            PropertyInfo inputsProperty = null;
            foreach( var property in properties )
            {
                if( property.PropertyType.IsGenericType &&
                    property.PropertyType.GetGenericTypeDefinition() == typeof( List<> ) &&
                    property.PropertyType.GetGenericArguments()[ 0 ] == typeof( string ) &&
                    property.Name == "Inputs" )
                {
                    inputsProperty = property;
                    inputsProperty.SetValue( options, new List<string>() );
                }
            }
            var optionProperties = properties.Where(
                property => property.GetCustomAttribute( typeof( OptionAttribute ) ) != null );
            for( int idxArg = 0; idxArg < args.Length; ++idxArg )
            {
                var arg = args[ idxArg ];
                if( arg.StartsWith( "--" ) )
                {
                    var posEqual = arg.IndexOf( '=' );
                    string key = posEqual < 0 ? arg : arg.Substring( 0, posEqual );
                    if( key == "--help" )
                    {
                        foreach( var property in optionProperties )
                        {
                            OptionAttribute option = property.GetCustomAttribute( typeof( OptionAttribute ) ) as OptionAttribute;
                            Console.WriteLine( $"{option.LongName} {option.Description}" );
                        }
                        return false;
                    }
                    PropertyInfo found = null;
                    foreach( var property in optionProperties )
                    {
                        OptionAttribute option = property.GetCustomAttribute( typeof( OptionAttribute ) ) as OptionAttribute;
                        if( option != null && option.LongName.Equals( key ) )
                        {
                            found = property;
                            break;
                        }
                    }
                    if( found == null )
                    {
                        Console.Error.WriteLine( $"invalid option ({key})" );
                        return false;
                    }
                    if( found.PropertyType == typeof( bool ) )
                    {
                        found.SetValue( options, true );
                    }
                    else
                    {
                        string valueStr;
                        if( posEqual < 0 )
                        {
                            if( ++idxArg >= args.Length )
                            {
                                Console.Error.WriteLine( $"{key} requires value." );
                                return false;
                            }
                            valueStr = args[ idxArg ];
                        }
                        else
                        {
                            valueStr = arg.Substring( posEqual + 1 );
                        }
                        var valueType = found.PropertyType.IsGenericType ?
                            found.PropertyType.GetGenericArguments()[ 0 ] : found.PropertyType;
                        object value = valueStr;
                        if( valueType != typeof( string ) )
                        {
                            var parse = valueType.GetMethod( "Parse", new[] { typeof( string ) } );
                            value = parse.Invoke( null, new object[] { valueStr } );
                        }
                        if( found.PropertyType.IsGenericType &&
                            found.PropertyType.GetGenericTypeDefinition() == typeof( List<> ) )
                        {
                            if( found.GetValue( options ) == null )
                            {
                                found.SetValue( options, Activator.CreateInstance( found.PropertyType ) );
                            }
                            dynamic list = found.GetValue( options );
                            list.Add( (dynamic)value );
                        }
                        else
                        {
                            found.SetValue( options, value );
                        }
                    }
                }
                else
                {
                    if( inputsProperty != null )
                    {
                        List<string> inputs = inputsProperty.GetValue( options ) as List<string>;
                        inputs.Add( arg );
                    }
                }
            }

            return true;
        }
    }
}
