# coding: UTF-8

# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.

import argparse
import codecs
import locale
import os
import re
import sys

import shlex
import subprocess

APP_ROOT   = os.path.dirname( os.path.abspath(__file__) )
SIGLO_ROOT = os.path.normpath( APP_ROOT + '/../../../..' )
CLANG_ROOT = os.path.normpath( SIGLO_ROOT + '/Externals/Binaries/libclang' )
sys.path.append( CLANG_ROOT + '/src/bindings/python' )
from clang import cindex
cindex. Config.set_library_path( CLANG_ROOT + '/bin' )

message = ""

def normalize_path(path):
    """パスを正規化します。

    Args:
        path:               正規化対象のパスです。
    Returns:
        区切り文字に / を使用する絶対パスです。
    """
    return os.path.abspath(path).replace('\\', '/')


def print_all_node_tree(filename, node, level):
    #for i in range(1, level):
    #    sys.stdout.write("-")
    #print "%s : %s" % (node.kind.name, node.displayname)

    # cindex.py の 1142 行目からある Cursor に定義されている情報を出力する
    if node.location.file is None:
        for child in node.get_children():
            print_all_node_tree(filename, child, level)
    elif filename == node.location.file.name:
        for i in range(1, level):
            sys.stdout.write("-")
        print ""
        print "%s : %s" % (node.kind, node.displayname)
        if node.is_definition():
            print "is_definition"
        if node.is_const_method():
            print "is_const_method"
        if node.is_mutable_field():
            print "is_mutable_field"
        if node.is_pure_virtual_method():
            print "is_pure_virtual_method"
        if node.is_static_method():
            print "is_static_method"
        if node.is_virtual_method():
            print "is_virtual_method"
        #print "%s" % (node.get_definition)
        #print "%s" % (node.get_usr)
        print "%s" % (node.kind)
        if node.kind.is_declaration():
            print "kind.is_declaration"
        if node.kind.is_reference():
            print "kind.is_reference"
        if node.kind.is_expression():
            print "kind.is_expression"
        if node.kind.is_statement():
            print "kind.is_statement"
        if node.kind.is_attribute():
            print "kind.is_attribute"
        if node.kind.is_invalid():
            print "kind.is_invalid"
        if node.kind.is_translation_unit():
            print "kind.is_translation_unit"
        if node.kind.is_preprocessing():
            print "kind.is_preprocessing"
        if node.kind.is_unexposed():
            print "kind.is_unexposed"
        #print "%s" % (node.spelling)
        #print "%s" % (node.displayname)
        #if node.kind.name == "FUNCTION_DECL":
        #    print "%s" % (node.mangled_name)
        #print "%s" % (node.location)
        #print "%s" % (node.extent)
        #print "%s" % (node.storage_class)
        #print "%s" % (node.access_specifier)
        #print "%s" % (node.type)
        #print "%s" % (node.canonical)
        #print "%s" % (node.result_type)
        #print "%s" % (node.underlying_typedef_type)
        #print "%s" % (node.enum_type)
        #print "%s" % (node.enum_value)
        #print "%s" % (node.objc_type_encoding)
        #print "%s" % (node.hash)
        #print "%s" % (node.semantic_parent)
        #print "%s" % (node.lexical_parent)
        #print "%s" % (node.translation_unit)
        #print "%s" % (node.referenced)
        #print "%s" % (node.brief_comment)
        #print "%s" % (node.raw_comment)
        #print "%s" % (node.get_arguments)
        #print "%s" % (node.get_num_template_arguments)
        #print "%s" % (node.get_template_argument_kind)
        #print "%s" % (node.get_template_argument_type)
        #print "%s" % (node.get_template_argument_value)
        #print "%s" % (node.get_template_argument_unsigned_value)
        #print "%s" % (node.walk_preorder)
        #print "%s" % (node.get_tokens)
        #print "%s" % (node.get_field_offsetof)
        #print "%s" % (node.is_anonymous)
        #print "%s" % (node.is_bitfield)
        #print "%s" % (node.get_bitfield_width)
        #print "%s" % (node.from_result)
        #print "%s" % (node.from_cursor_result)

        print ""
        for child in node.get_children():
            print_all_node_tree(filename, child, level+1)


def print_my_function_names(filename, node, namespace, level, is_struct_for_print_method_name, class_name):
    global message
    is_child_in_struct_for_print_method_name  = is_struct_for_print_method_name

    if node.location.file is None:
        message = ""
        for child in node.get_children():
            print_my_function_names(filename, child, namespace, level, is_struct_for_print_method_name, class_name)
    elif filename == node.location.file.name:
        level = level + 1
        if node.kind.name == "NAMESPACE":
            message += "using namespace " + namespace + node.displayname + ";\n"
            namespace = namespace + node.displayname + "::"
        if node.kind.name == "FUNCTION_DECL":
            message = message + namespace + node.displayname + "\n"
        if node.kind.name == "CLASS_DECL":
            if node.is_definition():
                message = message + namespace + node.displayname + "\n"
                class_name = node.displayname
        if node.kind.name == "STRUCT_DECL":
            if node.displayname != "" and node.is_definition():
                is_child_in_struct_for_print_method_name = True
                class_name = node.displayname
        if node.kind.name == "CXX_METHOD":
            if node.is_static_method():
                message = message + namespace + class_name + "::" + node.displayname + "\n"
            # static ではない関数を持つ構造体を一度だけ検出したいため、一度構造体の中に非static関数を見つけた場合は
            # 同じレベルでこの検出をしないようにする
            # struct 内 struct が関数を持っていた場合にも対応済み
            if is_struct_for_print_method_name == True and node.is_static_method() != True:
                message = message + namespace + class_name + "\n"
                is_struct_for_print_method_name = False
                #is_child_inner_struct = False
        for child in node.get_children():
            is_child_in_struct_for_print_method_name = print_my_function_names(filename, child, namespace, level, is_child_in_struct_for_print_method_name, class_name)
        return is_struct_for_print_method_name

def create_cpp_file(cpp_file_data, bundle_id_name):
    """
    Args:
        cpp_file_data:  cpp ファイルの生成元になるデータ
        bundle_id_name: cpp ファイルの名前になるバンドルのID
    """
    message = ""
    header_message = ""
    cpp_file_data = cpp_file_data.split("\n")

    print "=== " + bundle_id_name
    header_message += "// " + bundle_id_name + "\n\n"

    # NN_NORETURN 属性の関数呼び出し以降のコードも有効化するため、NN_NORETURN を上書きして無効化する必要がある
    header_message += "#include <nn/nn_Macro.h>" + "\n" + "#define NN_NORETURN" + "\n\n"

    # まずはヘッダファイル名の行を見つけて、include を列挙する
    lines_for_include = cpp_file_data
    for line in lines_for_include:
        if line.startswith("Programs"):
            header_message +=  "#include <" + line.rsplit("/Include/").pop().rstrip("\n") + ">\n"

    # 次に、引数の型名に namespace が書かれていないことがあるため、using を見つけて出力する
    lines_for_using = cpp_file_data
    for line in lines_for_using:
        if line.startswith("using "):
            header_message += line + "\n"

# 実装していない必要な処理
# (1) 関数の引数に namespace が必要なのに型名しか libclang が生成しないことがあるので、using を追加
# (2) explicit 指定された引数をひとつだけとるコンストラクタである変換コンストラクタだった場合の、コンストラクタありの呼び出し
# (3) explicit 指定がなくとも、コンストラクタとして引数を必ず要求するものがあれば、それを指定しなければいけない
# (4) abstract クラスをインスタンス化しようとしてしまっているので、回避する仕組みが必要
# (5) コンストラクタが protected なクラスもインスタンス化しようとしてしまっているので、回避する仕組みが必要
# (6) inline 関数の呼び出しが W 属性のシンボルになるのは、もう無視するしかないはず・・・
# (7) クラス内クラスはわざわざ定義する必要がないので、無視したいが、どうするべきか。書くとコンパイルエラーになるし。
# (8) 

    # 次は関数、クラスの呼び出しコードを生成する
    lines_for_api = cpp_file_data
    header_message += "\n\n" + "extern \"C\" void nnMain()" + "\n" + "{" + "\n"
    # 引数に構造体と思われるものを指定されていた場合に、ポインタに一旦キャストするための一時変数を用意する
    header_message += "    " + "int arg;\n\n"
    for line in lines_for_api:
        line = line.rstrip("\n")
        if line.startswith("Programs") == False and line.startswith("using ") == False:
            if line.find("(") != -1:
                print "function : %s" % line
                # 関数呼び出し
                # 引数がなければ、そのまま呼び出す
                if line.find("(") != -1 and line[line.find("(")+1] == ")":
                    message += "    " + line + ";\n"
                else:
                    # 引数の型にキャストした 0 を引数とする
                    left_paren = line.find("(")
                    left_paren += 1
                    function_string = line[:left_paren]
                    print "    " + function_string
                    right_side = line.rfind(")")

                    for i in range(1,10):
                        right_side = line[left_paren:].find(",")
                        if right_side == -1:
                            break;
                        right_side += left_paren
                        print "%d : %s" % (right_side, line[right_side-1])
                        if line[right_side-1] == '&':
                            print "Found &"
                            line[right_side-1].replace('&',' ')
                            function_string += "*(" + line[left_paren:right_side].strip("&") + "*)&arg,"
                        elif line[left_paren:right_side].find("(*)") != -1:
                            # 引数が関数ポインタの場合、関数ポインタのポインタにする必要がある
                            function_string += "*(" + line[left_paren:right_side].replace("(*)", "(**)") + ")&arg,"
                        else:
                            function_string += "*(" + line[left_paren:right_side] + "*)&arg,"
                        print "    " + function_string
                        left_paren = right_side + 1

                    right_paren = line.rfind(")")
                    if line[right_paren-1] == '&':
                        print "Found &"
                        line[right_paren-1].replace('&',' ')
                        function_string += "*(" + line[left_paren:right_paren].strip("&") + "*)&arg);\n"
                    elif line[left_paren:right_paren].find("(*)") != -1:
                        # 引数が関数ポインタの場合、関数ポインタのポインタにする必要がある
                        function_string += "*(" + line[left_paren:right_paren].replace("(*)", "(**)") + ")&arg);\n"
                    else:
                        function_string += "*(" + line[left_paren:right_paren] + "*)&arg);\n"
                    print "    " + function_string
                    print ""
                    message += "    " + function_string
            elif len(line) != 0:
                print "class or struct : %s" % line
                # クラス、構造体
                message += "    {\n"
                message += "        " + line + " instance;\n"
                message += "    }\n"

    if message != "":
        print "\n\n =====\n"
        print bundle_id_name
        print message
        print "=====\n\n"
        output_file = open(bundle_id_name + ".cpp", "w")
        output_file.write(header_message)
        output_file.write(message)
        output_file.write("}\n")
        output_file.close()


def bundle_to_cpp_files(bundle_file_list_uniq, clang_root_dir):
    global message
    """
    Args:
        input_file:  cpp ファイルを作成したいバンドルファイルのリスト(重複削除済み)
        clang_root_dir :  libclang で使用する Rynda のルートディレクトリ
    """
    build_options               = [

        # SDK をビルドする際と同じオプションを使います。
        '-Wall',
        '-Wimplicit-fallthrough',

        '-xc++',
        '-std=gnu++14',

        '-D', 'NN_NINTENDO_SDK',
        '-D', 'NN_SDK_BUILD_RELEASE',
        '-D', 'NN_SDK_BUILD_LIBRARY',
        '-I', os.path.normpath( SIGLO_ROOT + '/Programs/Chris/Include'),
        '-I', os.path.normpath( SIGLO_ROOT + '/Programs/Chris/Outputs/Include'),
        '-I', os.path.normpath( SIGLO_ROOT + '/Programs/Alice/Include'),
        '-I', os.path.normpath( SIGLO_ROOT + '/Programs/Alice/Outputs/Include'),
        '-I', os.path.normpath( SIGLO_ROOT + '/Programs/Eris/Include'),
        '-I', os.path.normpath( SIGLO_ROOT + '/Programs/Eris/Outputs/Include'),
        '-I', os.path.normpath( SIGLO_ROOT + '/Programs/Iris/Include'),
        '-I', os.path.normpath( SIGLO_ROOT + '/Programs/Iris/Outputs/Include'),
        '-I', os.path.normpath( SIGLO_ROOT + '/Common/Configs/Targets/NX-NXFP2-a64/Include'),
        '-I', os.path.normpath( clang_root_dir + '/nx/aarch64/include'),
        '-I', os.path.normpath( clang_root_dir + '/nx/aarch64/include/c++/v1'),
        '-I', os.path.normpath( clang_root_dir + '/nx/armv7l/include'),
        '-I', os.path.normpath( clang_root_dir + '/nx/armv7l/include/c++/v1'),
    ]

    index = cindex.Index.create()

    for bundle_file in bundle_file_list_uniq:
        message = ""
        cpp_file_data = ""
        bundleFile = open(bundle_file, "r")
        lines = bundleFile.readlines()
        bundleFile.close()
        # 引数はバンドルファイルの yml ファイルであり、これを id に変換する
        relative_bundle_file_path = bundle_file.replace(normalize_path(SIGLO_ROOT) + "/", '').rstrip("\n")
        relative_bundle_file_path = relative_bundle_file_path.replace("Integrate/Packages/", '').replace('/', '_')
        bundle_file_name = relative_bundle_file_path.replace(".bundle.yml", "")
        bundle_id_name = bundle_file_name.replace('.', '_')
        #filehandle = open(bundle_id_name + "-api-list.txt", "w")
        for line in lines:
            if re.search("\.h$", line) != None:
                if line.startswith("    - Programs/"):
                    line = line.strip("    - ")
                    print "=== " + line

                    # line の含まれる文字は Siglo ツリー直下からのファイルパスになっている
                    relativeHeaderFilePath = line.rstrip("\n")
                    headerFilePath = normalize_path(SIGLO_ROOT + "/" + line).rstrip("\n")

                    tu    = index.parse(headerFilePath, build_options)
                    severity  = ['Ignored', 'Note', 'Warning', 'Error', 'Fatal']
                    for diag in tu.diagnostics:
                        if diag.severity == 3:
                            if diag.spelling == "expected function body after function declarator":
                                # NN_NOEXCEPT 認識できないエラーは関数のリストアップ作業に致命的なのでエラーにする
                                raise
                    if not tu:
                        print('引数の指定が正しくありません')

                    print_my_function_names(headerFilePath, tu.cursor, "", 0, False, "")

                    if message != "":
                        #filehandle.write(relativeHeaderFilePath + "\n")
                        #filehandle.write(message)
                        # cpp ファイルとして生成するべき定義があるヘッダファイルだったので、cpp を作成するためにデータを貯める。
                        cpp_file_data += relativeHeaderFilePath + "\n" + message
        # cpp ファイルを作成する
        if cpp_file_data != "":
            create_cpp_file(cpp_file_data, bundle_id_name)
        #filehandle.close()


def main(input_file, clang_root_dir):
    """
    Args:
        input_file:  cpp ファイルを作成したいパッケージの一覧ファイル。
        clang_root_dir :  libclang で使用する Rynda のルートディレクトリ
    """

    # 引数はパッケージファイルの yml ファイルであり、これからバンドルファイルを抽出する
    # ただし、パッケージに存在しないがリストに追加したいバンドル、除外したいバンドルはここで指定しておく
    bundle_file_list = [normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleDefinitions/NX/OeReportUserIsActive.bundle.yml")]
    # v1.4 ブランチと、develop(NX Addon 3.0.0 以降) でバンドルファイルの構成が変わっているので、両方をサポートする。
    ignore_bundle_file_list = [normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleRules/Generic/Private/OceanKit/system.bundle.yml"), normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleRules/NX/Private/OceanKit/system.bundle.yml"), normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleRules/NX/Private/OceanKitFiles/OceanKitFiles.bundle.yml"), normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleRules/OceanKit/Generic/Files.system.bundle.yml"), normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleRules/OceanKit/NX/Files.system.bundle.yml"), normalize_path(SIGLO_ROOT + "/" + "Integrate/Packages/BundleRules/OceanKitFiles/NX/OceanKitFiles.bundle.yml")]

    packageFiles = open(input_file, "r")
    package_file_list = packageFiles.readlines()
    packageFiles.close()

    for packeage_file in package_file_list:
        packageFile = open(normalize_path(SIGLO_ROOT + "/" + packeage_file).rstrip("\n"), "r")
        lines = packageFile.readlines()
        packageFile.close()

        for line in lines:
            if re.search("\.bundle\.yml$", line) != None:
                line = re.sub(r'\s+-\s', "", line)
                # line の含まれる文字は Siglo ツリー直下からのファイルパスになっている
                bundle_file_path = normalize_path(SIGLO_ROOT + "/" + line).rstrip("\n")
                bundle_file_list.append(bundle_file_path)

    # リストの順序を変えないために、重複バンドルは for で削除する
    bundle_file_list_uniq = []
    for x in bundle_file_list:
        if x not in bundle_file_list_uniq and x not in ignore_bundle_file_list:
            bundle_file_list_uniq.append(x)

    bundle_to_cpp_files(bundle_file_list_uniq, clang_root_dir)


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--input', help='Package file list file')
    parser.add_argument('--clang', help='clang directory path')
    args = parser.parse_args()

    input_file = args.input
    clang_root_dir = args.clang

    main(input_file, clang_root_dir)
