﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Common
{
    public class MultiBranchTreeNode
    {
        protected MultiBranchTreeNode parent;
        protected List<MultiBranchTreeNode> childList;
        protected bool isHead = false;

        public MultiBranchTreeNode()
        {
            parent = null;
            childList = new List<MultiBranchTreeNode>();
        }

        public void SetParent(MultiBranchTreeNode item)
        {
            parent = item;
        }

        public void AddChild(MultiBranchTreeNode item)
        {
            childList.Add(item);
            item.SetParent(this);
        }

        public MultiBranchTreeNode GetParent()
        {
            return parent;
        }

        public void GetDirectChildList(ref List<MultiBranchTreeNode> directChildList)
        {
            directChildList = new List<MultiBranchTreeNode>(childList);
        }

        public void GetAllChildList(ref List<MultiBranchTreeNode> allChildList)
        {
            foreach (MultiBranchTreeNode child in childList)
            {
                allChildList.Add(child);
                child.GetAllChildList(ref allChildList);
            }
        }
    };

    public class MultiBranchTreeNodeHead : MultiBranchTreeNode
    {
        public MultiBranchTreeNodeHead() : base()
        {
            isHead = true;
        }

        public IEnumerator<MultiBranchTreeNode> GetEnumerator()
        {
            foreach (MultiBranchTreeNode child in childList)
            {
                List<MultiBranchTreeNode> allGrandChildList = new List<MultiBranchTreeNode>();
                child.GetAllChildList(ref allGrandChildList);
                yield return child;
                foreach (MultiBranchTreeNode grandChild in allGrandChildList)
                {
                    yield return grandChild;
                }
            }
        }
    }
}
