﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using LOG = Common.Logger;

namespace Common
{
    //TODO: 公開メソッドにコメント追加
    //      SetData()した時のみ更新するようにする
    public class FileIOWrapper
    {
        private struct FileInfo
        {
            public string PathName;
            public string FileData;
            public bool   IsModified;

            public FileInfo(string path)
            {
                PathName = path;
                IsModified = false;
                if (File.Exists(path))
                {
                    FileData = File.ReadAllText(path, Encoding.GetEncoding("UTF-8"));
                }
                else
                {
                    FileData = string.Empty;
                }
            }
        }
        private static List<FileInfo> FileInfoList = new List<FileInfo>();

        public static bool GetData(out string fileData, string path)
        {
            foreach (FileInfo inf in FileInfoList)
            {
                if (inf.PathName == path)
                {
                    fileData = inf.FileData;
                    return true;
                }
            }

            FileInfo info = new FileInfo(path);
            FileInfoList.Add(info);
            fileData = info.FileData;
            return true;
        }

        public static bool SetData(ref string fileData, string path)
        {
            int index = -1;
            int pos = 0;
            foreach (FileInfo inf in FileInfoList)
            {
                if (inf.PathName == path)
                {
                    index = pos;
                    break;
                }
                pos++;
            }
            if (index >= 0)
            {
                FileInfo inf = FileInfoList[index];
                inf.FileData = fileData;
                inf.IsModified = true;
                FileInfoList[index] = inf;
                return true;
            }
            FileInfo info = new FileInfo(path);
            info.FileData = fileData;
            info.IsModified = true;
            FileInfoList.Add(info);
            return true;
        }

        public static bool FlushAll()
        {
            foreach (FileInfo inf in FileInfoList)
            {
                if (inf.IsModified == true)
                {
                    string path = inf.PathName;
                    File.WriteAllText(path, inf.FileData, Encoding.GetEncoding("UTF-8"));
                    // LOG.Log("Written {0}\n", Path.GetFileName(path));
                }
            }
            return true;
        }
    }
}
