﻿/*--------------------------------------------------------------------------------*
  Copyright (C)2014-2015 Nintendo. All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
//using System.Text.RegularExpressions;

using LOG = Common.Logger;
using FILEIO = Common.FileIOWrapper;

namespace CheckForVsHelp
{
    public class CheckCss
    {
        private static string BuildDirectoryName = null;

        /// <summary>
        /// Build,Build_VsHelp用のstylesheet.cssがファイル同期が取れているかを確認します
        /// </summary>
        /// <param name="doxygenPath">ドキュメントパス(%SIGLO_ROOT%\Documents\Outputs\Api 相当)</param>
        /// <returns>ファイル同期が取れていれば true</returns>
        public static bool Check(string doxygenPath)
        {
            if (!Directory.Exists(doxygenPath))
            {
                LOG.Log(LOG.Level.LOG_ERROR, "directory not found : {0}", doxygenPath);
                return false;
            }
            BuildDirectoryName = CmdlineOption.InputDirectoryName;
            Common.UtilFs.SetVsHelpBaseDirName(CmdlineOption.InputDirectoryName);
            Common.UtilFs.SetVsHelpDirName(CmdlineOption.OutputDirectoryName);

            // 検索先のパスを作成する
            string css1path = doxygenPath + "\\" + BuildDirectoryName + "\\Template\\stylesheet.css";
            string css2path = doxygenPath + "\\" + BuildDirectoryName + "\\Template\\stylesheet.css";

            // ファイルの存在チェック
            if (!CheckCssFiles(css1path, css2path))
            {
                return false;
            }

            // Build_VsHelp側のcssファイルから追加行の先頭の行数を取得する
            int count_line = 0;
            if (!CountCss2AdditionalLineNumber(css2path, ref count_line))
            {
                return false;
            }
            // Build,Build_VsHelpの各行が一致するかを比較する
            return CheckCssFilesDifference(css1path, css2path, count_line);
        }

        private static bool CheckCssFiles(string css1path, string css2path)
        {
            if (!File.Exists(css1path))
            {
                LOG.Log(LOG.Level.LOG_WARN, "file not found : {0}", css1path);
                return false;
            }
            if (!File.Exists(css2path))
            {
                LOG.Log(LOG.Level.LOG_INFO, "stylesheet.css of Build_VsHelp is not found : {0}\n", css2path);
                return false;
            }
            return true;
        }

        private static bool CountCss2AdditionalLineNumber(string css2path, ref int count_line)
        {
            // Build_VsHelp側のcssファイルから追加行の先頭の行数を取得する
            string fileData;
            FILEIO.GetData(out fileData, css2path);
            using (StringReader sr2 = new StringReader(fileData))
            {
                string line = null;
                string prevline = null;
                count_line = 0;
                while (sr2.Peek() > -1)
                {
                    line = sr2.ReadLine();
                    if (line.Equals("/* customize for Build_VsHelp */"))
                    {
                        if (prevline == string.Empty)
                        {
                            // 空行はカウントから外す
                            count_line--;
                        }
                        break;
                    }
                    count_line++;
                    prevline = line;
                }
                if (sr2.Peek() == -1)
                {
                    LOG.Log(LOG.Level.LOG_WARN, BuildDirectoryName + "/Template/stylesheet.css has no additional code\n");
                    count_line = 0;
                    return false;
                }
            }
            return true;
        }

        private static bool CheckCssFilesDifference(string css1path, string css2path, int count_line)
        {
            // Build,Build_VsHelpの各行が一致するかを比較する
            string fileData1, fileData2;
            FILEIO.GetData(out fileData1, css1path);
            FILEIO.GetData(out fileData2, css2path);
            using (StringReader sr1 = new StringReader(fileData1), sr2 = new StringReader(fileData2))
            {
                string line1 = null;
                string line2 = null;
                int count = 0;
                while (sr1.Peek() > -1 && sr2.Peek() > -1)
                {
                    line1 = sr1.ReadLine();
                    line2 = sr2.ReadLine();
                    if (!line1.Equals(line2))
                    {
                        LOG.Log(LOG.Level.LOG_WARN, "stylesheet.css has difference between Build and Build_VsHelp (line={0})\n", count);
                        return false;
                    }
                    count++;
                    if (count > count_line)
                    {
                        return true;
                    }
                }
            }

            LOG.Log(LOG.Level.LOG_WARN, "stylesheet.css has difference between Build and Build_VsHellp\n");
            return false;
        }
    }
}
