﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using RETVAL = Common.ReturnValue;
using LOG = Common.Logger;

namespace AddMeta
{
    public class Program
    {
        public static int Main(string[] args)
        {
            int retval = RETVAL.ExitSuccess;
#if DEBUG
            Console.Write("AddMeta start\n");
#endif

            // 引数を取得
            if (!CmdlineOption.Parse(args))
            {
                retval = RETVAL.ErrorCmdlineOptionParse;
                goto quit;
            }
            if (CmdlineOption.DoxygenPath == null)
            {
                CmdlineOption.Usage();
                retval = RETVAL.ErrorSetBasePath;
                goto quit;
            }

            try
            {
                // ディレクトリパスの指定
                ParseAndWrite.SetPath(CmdlineOption.DoxygenPath);

                // XMLファイルからメソッド・ファイル名の組み合わせを取得する
                ParseAndWrite.Parse();
                // 該当するファイル名に対して meta を記述する
                // MEMO: バックアップを取った方がいい？
                ParseAndWrite.Write();
                // VsHelpでは空白文字を受け付けないので変換する
                ParseAndWrite.ConvertNbsp();

                // 変更するファイルをすべて書き出します
                Common.FileIOWrapper.FlushAll();
            }
            catch (Exception e)
            {
                Common.UtilException.DumpException(e);
                retval = RETVAL.ErrorException;
                goto quit;
            }

        quit:
#if DEBUG
            Console.Write("AddMeta end\n");
#endif
            return retval;
        }
    }
}
