﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Management.Automation;

namespace Nintendo.DotNetLocalizer
{
    [Cmdlet(VerbsData.Update, "LocalizationItem")]
    public class UpdateLocalizationItemCommand : Cmdlet
    {
        [Parameter(Mandatory = true,
                   Position = 0)]
        [AllowNull]
        [AllowEmptyCollection]
        public LocalizationItem[] Japanese { get; set; }

        [Parameter(Mandatory = true,
                   Position = 1)]
        [AllowNull]
        [AllowEmptyCollection]
        public LocalizationItem[] English { get; set; }

        [Parameter(Mandatory = true,
                   Position = 2)]
        [AllowNull]
        [AllowEmptyCollection]
        public LocalizationItem[] RefJapanese { get; set; }

        [Parameter]
        public SwitchParameter New { get; set; }

        protected override void ProcessRecord()
        {
            var e =
                LocalizationItem.UpdateLocalizeItem(
                    Japanese ?? LocalizationItem.EmptyArray,
                    English ?? LocalizationItem.EmptyArray,
                    RefJapanese ?? LocalizationItem.EmptyArray,
                    New.IsPresent);
            WriteObject(e, true);
        }
    }
}
