﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Nintendo.Foundation.IO;

namespace ChangePoEncoding
{
    class ChangePoEncodingArgs
    {
        private ChangePoEncodingParams parameters;

        /// <summary>
        /// 解析した結果のパラメータを渡します。
        /// </summary>
        public ChangePoEncodingParams Params
        {
            get { return parameters; }
        }

        /// <summary>
        /// コマンドラインオプションを解析します
        /// </summary>
        /// <returns>解析の成否</returns>
        public bool ParseArgs(string[] args)
        {
            var settings = new CommandLineParserSettings()
            {
                ApplicationDescription = ".po ファイルの文字エンコーディングを、msgfmt が扱える形式に変換します",
                HelpWriter = text =>
                {
                    Console.WriteLine(text);
                },
            };

            if (!new CommandLineParser(settings).ParseArgs(args, out parameters))
            {
                return false;
            }

            return true;
        }

        /// <summary>
        /// 引数解析が失敗したときに呼ばれるメソッドです。
        /// </summary>
        /// <param name="errorInfo">エラーの情報</param>
        private void CommandLineParseError(CommandLineErrorInfo errorInfo)
        {
            Console.Error.WriteLine("CommandLine: {0}", errorInfo.ErrorMessage);
        }
    }
}
