:: ---------------------------------------------------------------------------
::  Copyright (C)Nintendo All rights reserved.
::
::  These coded instructions, statements, and computer programs contain proprietary
::  information of Nintendo and/or its licensed developers and are protected by
::  national and international copyright laws. They may not be disclosed to third
::  parties or copied or duplicated in any form, in whole or in part, without the
::  prior written consent of Nintendo.
::
::  The content herein is highly confidential and should be handled accordingly.
:: ---------------------------------------------------------------------------

@echo off

setlocal

echo Setup CodingChecker

set REPOSITORY_ROOT=%~dp0..\..\..\..\

:: ---------------------------------------------------------------------------
:: Build CodingChecker
:: ---------------------------------------------------------------------------
for /f "usebackq tokens=*" %%i in (`"%REPOSITORY_ROOT%Integrate\CommandLineTools\LocateVsInstallation.exe" --basic`) do set VS150INSTALLDIR=%%i
if not exist "%VS150INSTALLDIR%" goto :error_no_vs150

"%REPOSITORY_ROOT%Externals\NuGet.Client\4.1.0\NuGet.exe" restore "%~dp0CodingChecker.sln" -Source "%REPOSITORY_ROOT%Externals\NuGetFeed" -Verbosity quiet -MSBuildPath "%VS150INSTALLDIR%\MSBuild\15.0\Bin"
if errorlevel 1 exit /B %ERRORLEVEL%

call "%VS150INSTALLDIR%\Common7\Tools\VsMSBuildCmd.bat" 1> nul

msbuild /p:Platform="Any CPU";Configuration=Release /v:quiet /nologo "%~dp0CodingChecker.sln"
if errorlevel 1 exit /B %ERRORLEVEL%


:: ---------------------------------------------------------------------------
:: Check git directories
:: ---------------------------------------------------------------------------
set GIT_DIRECTORY=%REPOSITORY_ROOT%.git\
if not exist "%GIT_DIRECTORY%" goto :error_no_git_directory

set GIT_HOOK_DIRECTORY=%GIT_DIRECTORY%hooks\
if not exist "%GIT_HOOK_DIRECTORY%" mkdir "%GIT_HOOK_DIRECTORY%"


:: ---------------------------------------------------------------------------
:: Install CodingChecker
:: ---------------------------------------------------------------------------
call "%~dp0install.cmd" "%GIT_HOOK_DIRECTORY%"

:: ---------------------------------------------------------------------------
:: Success and exit
:: ---------------------------------------------------------------------------
exit /b 0


:: ---------------------------------------------------------------------------
:: Error and exit
:: ---------------------------------------------------------------------------
:error_no_vs150
echo Could not detect MSBuild installation location. Please install either Visual Studio 2017 or Microsoft Build Tools 2017.
exit /b 1

:error_no_git_directory
echo ASSERTION FAILURE: Git directory not found.
exit /b 1

