﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Reflection;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace CommitLogChecker
{
    internal class CommitLogConverter
    {
        private const string JiraKeySubstituteString = "$(JIRA-KEY)";   // 課題キーの代わりに記述する文字列（課題キーに置換される）

        private string m_BranchName { get; }
        private string[] m_JiraKeys { get; }

        internal CommitLogConverter(string branchName, IEnumerable<string> jiraKeys)
        {
            m_BranchName = branchName;
            m_JiraKeys = jiraKeys.ToArray();
        }

        // ブランチ名から課題キーが取得できる場合、$(JIRA-KEY) を課題キーに置換して返す
        internal string ReplaceJiraKeySubstitute(string commitLog)
        {
            string issueKey = GetJiraIssueIdFromBranchName(m_BranchName, m_JiraKeys);
            if (string.IsNullOrEmpty(issueKey))
            {
                return commitLog;
            }

            return commitLog.Replace(JiraKeySubstituteString, issueKey);
        }

        // ブランチ名から課題キーを取得する
        private static string GetJiraIssueIdFromBranchName(string branchName, string[] jiraKeys)
        {
            var jiraKeyRegex = new Regex(string.Format(@"(({0})-\d+)", string.Join("|", jiraKeys)));

            var m = jiraKeyRegex.Match(branchName);
            if (!m.Success)
            {
                return null;
            }

            return m.Value;
        }
    }
}
