﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.IO;
using System;
using System.Reflection;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace CommitLogChecker
{
    internal class CommitLogCheckerParams
    {
        [CommandLineOption("input", IsRequired = true, ValueName = "path_to_commit_log_file", Description = "The path to commit log file")]
        public string CommitLogFile { get; set; }

        [CommandLineOption("output", IsRequired = true, ValueName = "path_to_replaced_commit_log_file", Description = "The path to replaced commit log file")]
        public string OutputFile { get; set; }

        [CommandLineOption("jira-key-list", IsRequired = false, ValueName = "path_to_jira_key_list", Description = "The path to jira key list")]
        public string JiraKeyListFile { get; set; }

        [CommandLineOption("branch-name", IsRequired = false, ValueName = "branch_name", Description = "Branch name")]
        public string BranchName { get; set; }
    }
}
