﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CodingCheckerUtil
{
    public class RefInfo
    {
        // HACK: 同値比較を Tuple に委譲する
        private Tuple<string, string> _value;

        /// <summary>
        /// ref の名前
        /// </summary>
        public string Name => _value.Item1;
        /// <summary>
        /// ref に関連付けられたコミット
        /// </summary>
        public string Commit => _value.Item2;

        public RefInfo(string name, string commit)
        {
            this._value = Tuple.Create(name, commit);
        }

        public override bool Equals(object obj)
        {
            if (obj == null || GetType() != obj.GetType())
            {
                return false;
            }

            var other = obj as RefInfo;
            return EqualityComparer<Tuple<string, string>>.Default.Equals(this._value, other._value);
        }

        public override string ToString() => _value.ToString();
        public override int GetHashCode() => _value.GetHashCode();
        public static bool operator ==(RefInfo lhs, RefInfo rhs) => EqualityComparer<Tuple<string, string>>.Default.Equals(lhs._value, rhs._value);
        public static bool operator !=(RefInfo lhs, RefInfo rhs) => !(lhs == rhs);
    }
}
