﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.IO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CodeChecker
{
    internal class CodeCheckerParams
    {
        [CommandLineValues(CountMin = 1, ValueName = "path", Description = "Target file path(s)")]
        public string[] Paths { get; set; }

        [CommandLineOption("recurse", IsRequired = false, DefaultValue = false, Description = "Check files in all child directories of target path")]
        public bool Recurse { get; set; }

        [CommandLineOption("target_extension_list", IsRequired = false, ValueName = "path_to_target_extension_list", Description = "The path to target extension list file")]
        public string TargetExtensionListFile { get; set; }
    }
}
