﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using System.Xml.XPath;

namespace ApiLinkRewriter
{
    /**
     * <summary> タグ情報ファイルの Api リンク情報を管理 </summary>
     */
    class TagInfomation
    {
        /**
         * <summary>xml ファイルからタグ情報を読み込む</summary>
         * <returns>ApiLink 型のリスト</returns>
        */
        public static List<ApiLink> ReadTagInfo(string[] tagFilePaths, OutputLog.LogLevel logLevel, string preApiUrl) {
            var syncObject = new Object();
            List<ApiLink> apiInfo = new List<ApiLink>();
            Parallel.ForEach(tagFilePaths, (tagInfoPath) =>
            {
                if (!File.Exists(tagInfoPath))
                {
                    OutputLog.WriteError(string.Format("Not exist {0}. Skip.", tagInfoPath));
                    throw new FileNotFoundException(string.Format("Not exist xml file. {0}", tagFilePaths));
                }
                OutputLog.WriteDetail(string.Format("Load Tagfile {0}.", tagInfoPath), logLevel);

                var doc = XDocument.Load(tagInfoPath);
                var package = doc.XPathSelectElement("TagInformation/Package");
                var apiDir = doc.XPathSelectElement("TagInformation/ApiDirectory");

                var childList =
                    from el in doc.XPathSelectElements("TagInformation/LinkList/Link")
                    select el;
                foreach (var e in childList)
                {
                    var html = new StringBuilder();

                    // html を調整
                    if (e.Element("Label").Value != "")
                    {
                        html.Append(preApiUrl);
                        html.Append(apiDir.Value);
                        html.Append(e.Element("Html").Value);
                        html.Append("#");
                        html.Append(e.Element("Label").Value);
                    }
                    else
                    {
                        html.Append(preApiUrl);
                        html.Append(apiDir.Value);
                        html.Append(e.Element("Html").Value);
                    }

                    // ApiLink 形式に変換
                    var name = "ApiLink_";
                    name += e.Element("Name").Value.Replace(":", "_");
                    lock (syncObject)
                    {
                        apiInfo.Add(new ApiLink(e.Element("Type").Value, name, html, package.Value));
                    }
                }
            });
            return apiInfo;
        }

    }
}
