﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ApiLinkRewriter
{
    /**
     * <summary>ログ出力を管理</summary>
     */
    class OutputLog
    {
        public enum LogLevel
        {
            Quiet, Default, Detail
        }
        public enum LogType
        {
            Detail, Log, Error, DetailOnly, LogOnly, QuietOnly
        }
        /**
         * <summary> logLevel にあう logType のログを表示。</summary>
         * <param name = "logType">ログの種類</param>
         * <param name = "str">ログ</param>
         * <param name = "logLevel"> ログの表示レベル。Detail は logType が Log と Dtail のログを表示。Default では logType が Log のログを表示。 Quiet は logType が QuietOnly のログ以外表示しない。</param>
         */
        private static void WriteHostLog(LogType logType, string str, LogLevel logLevel)
        {
            switch (logType)
            {
                case LogType.Detail:
                    if (logLevel >= LogLevel.Detail)
                    {
                        Console.WriteLine(str);
                    }
                    break;
                case LogType.Log:
                    if (logLevel >= LogLevel.Default)
                    {
                        Console.WriteLine(str);
                    }
                    break;
                case LogType.Error:
                    Console.Error.WriteLine(str);
                    break;
                case LogType.DetailOnly:
                    if (logLevel == LogLevel.Detail)
                    {
                        Console.WriteLine(str);
                    }
                    break;
                case LogType.LogOnly:
                    if (logLevel == LogLevel.Default)
                    {
                        Console.WriteLine(str);
                    }
                    break;
                case LogType.QuietOnly:
                    if (logLevel == LogLevel.Quiet)
                    {
                        Console.WriteLine(str);
                    }
                    break;
                default:
                    Console.WriteLine("Cannot find log diagnosis. ({0})", str);
                    throw new ArgumentException("Invalid log type is specified.");
            }

        }
        /**
         * <summary> Error のログを表示。 </summary>
         * <param name = "str">ログ</param>
         */
        public static void WriteError(string str)
        {
            WriteHostLog(LogType.Error,"*** Error: " + str, LogLevel.Default);
        }
        /**
         * <summary> Warning のログを表示。 </summary>
         * <param name = "str">ログ</param>
         */
        public static void WriteWarning(string str)
        {
            WriteHostLog(LogType.Error,"*** Warning: " + str, LogLevel.Default);
        }
        /**
         * <summary> 動作の詳細を含めたログを表示。 </summary>
         * <param name = "str">ログ</param>
         * <param name = "logLevel"> ログの表示レベル。Detail の時は表示。</param>
         */
        public static void WriteDetail(string str, LogLevel logLevel)
        {
            WriteHostLog(LogType.Detail, str, logLevel);
        }
        /**
         * <summary> ログを表示。ただし動作の詳細は含めない。 </summary>
         * <param name = "str">ログ</param>
         * <param name = "logLevel"> ログの表示レベル。Detail と Log の時は表示。</param>
         */
        public static void WriteLog(string str, LogLevel logLevel)
        {
            WriteHostLog(LogType.Log, str, logLevel);
        }
    }
}
