﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Write kernel

    .DESCRIPTION
        Write kernel by flash tools.
#>

param
(
    [string]
    # The host IP address pattern as RegularExpression
    $AddressPattern = '.*'
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
Import-Module "${scriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\Path"
Import-Module "${scriptDirectoryPath}\Modules\HtcDaemon"
Import-Module "${scriptDirectoryPath}\Modules\Runner"
Import-Module "${scriptDirectoryPath}\Modules\WindowsErrorReporting"

$FlashToolDirectoryPath = "$(Get-NintendoSdkRootPath)/Externals/Binaries/Sdev15FlashTool"
$SdevHostBridgeConsolePath = "$(Get-NintendoSdkRootPath)/Externals/HostBridge/tools/SDEVGpioControl/Resources/Console.exe"

<#
    .SYNOPSIS
        Get a sigle target address
#>
function Get-Sigle-Target-Address
{
    param
    (
        [string]
        # The host IP address pattern as RegularExpression
        $AddressPattern = '.*'
    )

    $EnumerateOutput = Invoke-Expression "& `"$SdevHostBridgeConsolePath`" --Enumerate"

    $TargetCount = (
            Write-Output $EnumerateOutput | 
            ForEach-Object { $_.Split(",")[1].Trim() } | 
            Where-Object { $_ -match "[0-9]+`.[0-9]+`.[0-9]+`.[0-9]+" } | 
            Where-Object { $_ -match $AddressPattern } | 
            Tee-Object -Variable TargetAddress | 
            Measure-Object
        ).Count

    if($LastExitCode -ne 0)
    {
        throw "Target enumeration failed. ExitCode = $LastExitCode"
    }

    if($TargetCount -ne 1)
    {
        Write-Output $EnumerateOutput
        throw "Failed to find single target. NumTarget = $TargetCount"
    }

    return $TargetAddress
}

function Invoke-Critical-Command()
{
    param
    (
        [string]
        # Invoked expression
        $Expression
    )

    Write-Output "$Expression"
    Invoke-Expression $Expression
    if($LastExitCode -ne 0)
    {
        throw "Command failed.`n    Command=$Expression`n    ExitCode = $LastExitCode"
    }
}

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Disable-WindowsErrorReporting

if(-not $(Get-HtcDaemonState))
{
    Start-HtcDaemon
}

$TargetAddress = Get-Sigle-Target-Address -AddressPattern $AddressPattern

Set-Location $FlashToolDirectoryPath
Invoke-Critical-Command "& ./bin/tegraparser --pt flash_t210_sdev_normal.xml"
Invoke-Critical-Command "& ./bin/tegrahost --chip 0x21 --partitionlayout flash_t210_sdev_normal.bin --list images_list.xml"
Invoke-Critical-Command "& ./bin/tegrarcm --rcm rcm_list_signed.xml"
Invoke-Critical-Command "& ./bin/tegrarcm --download bct bct_odin_fp_02_00_normal.bct"
Invoke-Critical-Command "& ./bin/tegrarcm --oem platformdetails storage storage_info.bin"
Invoke-Critical-Command "& ./bin/tegrarcm --download dtb tegra210-odin-fp-02-00.dtb 0 --download ebt cboot.bin 0 0"
Invoke-Critical-Command "& ./bin/tegradevflash --pt flash_t210_sdev_normal.bin --storageinfo storage_info.bin --create"
Invoke-Critical-Command "& ./bin/tegradevflash --write BCT bct_odin_fp_02_00_normal.bct"
Invoke-Critical-Command "& ./bin/tegradevflash --reboot coldboot"
