<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Crate Process List Module

    .DESCRIPTION
        This file defines functions for creating process list
#>

param
(
    [bool]
    # Check if Visual Studio is running
    $CheckVisualStudioRunning = $true
)

#
# Import submodules
#
$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
Import-Module "${scriptDirectoryPath}\Modules\Path"
Import-Module "${scriptDirectoryPath}\Modules\VisualStudio"


#
# Entry point
#

if ($CheckVisualStudioRunning -and $(Test-VisualStudioRunning))
{
    Write-Host "Error: Visual Studio is running"
    exit 1
}

Write-Host "Uninstalling..."

$expression = "cmd /c `"$(Get-NintendoSdkRootPath)\Integrate\Packages\InstallScript\TargetManager\Uninstall.bat`""
Invoke-Expression $expression
if ($LASTEXITCODE -ne 0)
{
    Write-Host "Error: '${expression}' failed."
    exit ${LASTEXITCODE}
}

$expression = "cmd /c `"$(Get-NintendoSdkRootPath)\Integrate\Packages\InstallScript\VsiForNX\Uninstall.bat`""
Invoke-Expression $expression
if ($LASTEXITCODE -ne 0)
{
    Write-Host "Error: '${expression}' failed."
    exit ${LASTEXITCODE}
}

Write-Host "Done."
