<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Launches the Ocean home screen

    .DESCRIPTION
        - Launches the Ocean home screen using the DevMenu
        - Bypass the Ocean set up screen
        
#>

param
(
    [string]
    # Device's IP address
    $TargetAddress =
    ($env:TARGET_ADDRESS | ? { $_ } | % { $_.Trim() })
)

# switch to Ocean home screen
& Tools\CommandLineTools\ControlTarget.exe connect
& Tools\CommandLineTools\RunOnTarget.exe ./Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/DevMenuCommandSystem/Develop/DevMenuCommandSystem.nsp -- debug switch-menu homemenu

# bypass the Ocean set up screen by importing a settings file	
& Tools\CommandLineTools\RunOnTarget.exe ./Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/SettingsManager/Develop/SettingsManager.nsp -- Import "Tests\Stress\Ocean_Settings\ocean_settings.json"
& Tools\CommandLineTools\ControlTarget.exe reset --hard --target $TargetAddress
&  Tools\CommandLineTools\ControlTarget.exe connect

# make sure the Ocean home screen has time to completely load
Start-sleep -s 60