<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Copies files from the SD card on the device to the host PC.

    .DESCRIPTION
        - Copies all files from sd:/NxbinLogs directory to <sigloRoot>\Integrate\Outputs\AnyCPU\Tools\NxAgingTools\NxAgingHelperCommand\Release
        - Parses the *.nxbinlog files to text files and saves them as *.nxbinlog.log
        
#>

param
(
    [string]
    # SDK root directory
    $sigloRoot =
    ($env:NINTENDO_SDK_ROOT | ? { $_ } | % { $_.Trim() }),

    [string]
    # eg.  --enable-sdev-usb-event --enable-power-button-event
    $NxAgingCommands =
    ($env:TEST_NXAGING_COMMANDS)
)

# get the root path for the repo
$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

# go to the root directory
Set-Location -Path $env:NINTENDO_SDK_ROOT

# global values
$NX_AGING_WORKING_DIR = "$sigloRoot\Integrate\Outputs\AnyCPU\Tools\NxAgingTools\NxAgingHelperCommand\Release"

# sleep/wake command needs special handling
$NX_AGING_COMMAND_SLEEP = "--enable-power-button-event"

# if this is a sleep/wake test, copy the *.nxbinlog from the device to the host
if ($NxAgingCommands -match $NX_AGING_COMMAND_SLEEP)
{
    Write-Host "--- Copying logs for sleep/wake"
    Start-Process -FilePath "Tools\CommandLineTools\RunOnTarget.exe" -ArgumentList "./Tests/Outputs/NX-NXFP2-a64/Tests/GetSdCardFiles/Develop/GetSdCardFiles.nsp -- --read_dir=sd:/NxBinLogs --write_dir=$NX_AGING_WORKING_DIR" -Wait
    Start-Process -FilePath "Tests\Outputs\AnyCPU\Tools\ParseNxBinLogs\Release\ParseNxBinLogs.exe" -ArgumentList "$NX_AGING_WORKING_DIR"
}
