﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Stop logging of HostBridge

    .DESCRIPTION
        Stop logging of HostBridge.
#>

param
(
    # The host IP address pattern as RegularExpression
    [string]
    $AddressPattern = $env:TARGET_ADDRESS_PATTERN
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}\Modules\Path"
Import-Module "${scriptDirectoryPath}\Modules\HostBridge"

if (-not $AddressPattern)
{
    # If AddressPattern is not specified and env:TARGET_ADDRESS_PATTERN is not difined
    $AddressPattern = "169.*";
}

# Get the address of the HostBridge
$TargetAddress = Get-SigleTargetAddress -AddressPattern $AddressPattern
Stop-SaveHostBridgeLog -HostBridgeAddress $TargetAddress