﻿# powershell -File replacer.ps1 -ZarfDefinition NvnDriver.zarf.yml -InfoFile info.json

Param
(
    [Parameter(Mandatory=$true)]
    [string] $ZarfDefinition,

    [Parameter(Mandatory=$true)]
    [string] $NvnPath,

    [Parameter(Mandatory=$true)]
    [string] $SevenZipPath,

    [Parameter(Mandatory=$true)]
    [string] $OutputDirectory
)

$scriptDir = Split-Path $MyInvocation.MyCommand.Path -Parent

Import-Module $scriptDir/../Modules/Error
Import-Module $scriptDir/../Modules/Path

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$ErrorActionPreference = "Stop"

$sdkRoot = Get-NintendoSdkRootPath

Add-type -Path $sdkRoot/Externals/Binaries/YamlDotNet-3.0.0/YamlDotNet.dll

function Import-Yaml
{
    Param(
        [parameter(Mandatory = $true)]
        [string]$Path
    )

    $deserializer = New-Object YamlDotNet.Serialization.Deserializer ($null, $null)
    try {
        $sr = New-Object IO.StreamReader ($Path, [Text.Encoding]::UTF8, $true)
        $deserializer.Deserialize($sr)
    } finally {
        if ($sr) {
            $sr.Close()
        }
    }
}

if (Test-Path $OutputDirectory) {
    Remove-Item $OutputDirectory -Recurse
}

$zarfDef = Import-Yaml $ZarfDefinition 
$nvnVersion = $zarfDef["Zarf"]["VersionFile"]

# ファイルのバージョン文字列の作成
$nvnVersion -match '^\d+\.\d+' > $null
$fileVersion = $Matches[0]

& $SevenZipPath x "-o$OutputDirectory\win7-win8" "$NvnPath\${fileVersion}_generic_win8_winvista_win7_64bit_international_nvn.zip" |
Where-Object { $_ -notmatch '^Extracting ' } |
Write-Host

& $SevenZipPath x "-o$OutputDirectory\win10" "$NvnPath\${fileVersion}-generic_win10_64bit_international_nvn.zip" |
Where-Object { $_ -notmatch '^Extracting ' } |
Write-Host
