﻿Param
(
    [Parameter(Mandatory=$true)]
    [string] $VsixDir,

    [Parameter(Mandatory=$true)]
    [string] $OutputDir
)

$scriptDir = Split-Path $MyInvocation.MyCommand.Path -Parent

Import-Module $scriptDir/../Modules/Error
Import-Module $scriptDir/../Modules/Path

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$ErrorActionPreference = "Stop"

$sdkRoot = Get-NintendoSdkRootPath

# パッケージする TargetManager の特定
$vsix = Get-ChildItem $VsixDir\VsiForNX_*

if (Test-Path $OutputDir) {
    Remove-Item $OutputDir -Recurse
}
$dstDir = mkdir $OutputDir

# vsix のコピー
Copy-Item $vsix $dstDir.FullName

