﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Build Performance Documents
#>

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${ScriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\TeamCity"
Import-Module "${ScriptDirectoryPath}\Modules\Path"

# 例外ハンドラ
trap [Exception]
{
	Write-ErrorRecord $_
	exit 1
}

############################################################################
#
# ディレクトリパス
#
############################################################################

# NintendoSdkRoot ディレクトリ
$NintendoSdkRoot = NintendoSdkRootPath

# Documents ディレクトリ
$DocumentsRoot = NintendoSdkDocumentsRootPath

# Documents\Performance ディレクトリ
$PerformanceDocumentsRoot = "${DocumentsRoot}\Performance"

# Documents\Performance\Html ディレクトリ
$PerformanceDocumentsOutputRoot = "${PerformanceDocumentsRoot}\Html"

# MakeDataDocuments ツールルート
$MakeDataDocumentsRoot = "${NintendoSdkRoot}\Programs\Chris\Outputs\AnyCPU\Tools\DataDocumentTools"

# Externals ディレクトリ
$ExternalRoot = "${NintendoSdkRoot}\Externals"

############################################################################
#
# ツールパス
#
############################################################################

# MakeDataDocument.exe
$MakeDataDocumentTool = "${MakeDataDocumentsRoot}\MakeDataDocument\Release\MakeDataDocument.exe"


############################################################################
#
# 1. ビルド
#
############################################################################

cd "${PerformanceDocumentsRoot}\Config"

$LogFiles = Get-ChildItem . | Where-Object { $_.name -like "*.config" }

foreach( $file in ${LogFiles} ){
	Invoke-Expression "& `"${MakeDataDocumentTool}`" $file"
	if ( $LastExitCode -ne 0 ) { exit $LastExitCode }
}

############################################################################
#
# 2. 必要なファイルのコピー
#
############################################################################

# コマンドに失敗した場合に例外が発生するように
$ErrorActionPreference = "Stop"

### d3.js
$D3jsToolSource = "${ExternalRoot}\Binaries\d3js"
$D3jsToolOutput = "${PerformanceDocumentsOutputRoot}\js\d3"

mkdir -Force ${D3jsToolOutput}

cp -Force ${D3jsToolSource}\d3.js ${D3jsToolOutput}
cp -Force ${D3jsToolSource}\d3.min.js ${D3jsToolOutput}

### nvd3.js
$Nv3jsToolSource = "${ExternalRoot}\Binaries\nvd3js"
$Nv3jsToolOutput = "${PerformanceDocumentsOutputRoot}\js\nvd3"
$Nv3jsToolCssOutput = "${PerformanceDocumentsOutputRoot}\css\nvd3"

mkdir -Force ${Nv3jsToolOutput}
mkdir -Force ${Nv3jsToolCssOutput}

cp -Force ${Nv3jsToolSource}\nv.d3.js ${Nv3jsToolOutput}
cp -Force ${Nv3jsToolSource}\nv.d3.min.js ${Nv3jsToolOutput}
cp -Force ${Nv3jsToolSource}\nv.d3.css ${Nv3jsToolCssOutput}
cp -Force ${Nv3jsToolSource}\nv.d3.min.css ${Nv3jsToolCssOutput}

### jQuery
$jQueryToolSource = "${ExternalRoot}\Binaries\jQuery\dist"
$jQueryToolOutput = "${PerformanceDocumentsOutputRoot}\js\jQuery"

mkdir -Force ${jQueryToolOutput}

cp -Force ${jQueryToolSource}\jquery.js ${jQueryToolOutput}
cp -Force ${jQueryToolSource}\jquery.min.js ${jQueryToolOutput}
