<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Write the Bct by FRCM
#>
[CmdletBinding()]
Param
(
    [string]
    $Bct = '', # Default, <BctFile>

    [string]
    $KeyType = 'K5' # K1, K2, K3, K5, M1, M2
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../Modules/Runner"
Import-Module "${scriptDirectoryPath}/../../Modules/UsbTarget"

$RcmWriter          = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.exe"
$RcmWriterRcm       = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.$KeyType.rcm"
$RcmWriterRcmOld    = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.$KeyType.old.rcm"
$RcmWriterAdditionalOptions = ""
if($KeyType -eq 'M1')
{
    $RcmWriterXml       = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/RcmWriter/Write-Bct-M1.xml"
}
elseif($KeyType -eq 'M2')
{
    $RcmWriterXml       = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/RcmWriter/Write-Bct-M2.xml"
    $RcmWriterAdditionalOptions = "--old_rcm `"$RcmWriterRcmOld`""
}
else
{
    $RcmWriterXml       = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/RcmWriter/Write-Bct.xml"
}
$BctDefault         = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/BootLoader/Normal-$KeyType.bct"

$OutputDirectory    = "$(Get-NintendoSdkRootPath)/Integrate/Outputs/RcmWriter"
$OutputConfig       = "$OutputDirectory/RcmWriterConfig.xml"
$OutputBct          = "$OutputDirectory/Bct.img"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if (!(Test-Path $OutputDirectory)) {
    mkdir $OutputDirectory > $null
}

if($Bct -ne "" -and $Bct -ne "Default")
{
    if(Test-Path $Bct)
    {
        $BctFile = $Bct
    }
    else
    {
        throw "Not found the boot config file: $Bct"
    }
}
else
{
    $BctFile = $BctDefault
}

cp $BctFile $OutputBct
Write-Host "  BctFile:  $BctFile"

# Test existing files
Test-EnsureExistPath $RcmWriter
Test-EnsureExistPath $RcmWriterRcm
Test-EnsureExistPath $RcmWriterXml
Test-EnsureExistPath $BctFile

# Copy files
cp $RcmWriterXml $OutputConfig

# RcmWriter
Invoke-CriticalCommand "& `"$RcmWriter`" --rcm `"$RcmWriterRcm`" --list `"$OutputConfig`" $RcmWriterAdditionalOptions"
