<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Dump boot images by FRCM
#>
[CmdletBinding()]
Param
(
    [string]
    $OutputName = '',

    [string]
    $KeyType = 'K5' # K1, K2, K3
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../Modules/Runner"
Import-Module "${scriptDirectoryPath}/../../Modules/UsbTarget"

$RcmWriter          = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.exe"
$RcmWriterRcm       = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.$KeyType.rcm"
$RcmWriterRcmOld    = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.$KeyType.old.rcm"
$RcmWriterXml       = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/RcmWriter/Dump-CalImage.xml"
$RcmWriterAdditionalOptions = ""

if($KeyType -eq 'M2')
{
    $RcmWriterAdditionalOptions = "--old_rcm `"$RcmWriterRcmOld`""
}

$DefaultName        = Get-Date -Format "yyyy-MMdd-HHmmss"
$OutputDirectoryRoot= "$(Get-NintendoSdkRootPath)/Integrate/Outputs/DumpedCalImage"
if($OutputName -ne "")
{
    $OutputDirectory = "$OutputDirectoryRoot/$OutputName"   
}
else
{
    $OutputDirectory    = "$OutputDirectoryRoot/$DefaultName"
}
$OutputConfig       = "$OutputDirectory/RcmWriterConfig.xml"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

# Test existing files
Test-EnsureExistPath $RcmWriter
Test-EnsureExistPath $RcmWriterRcm
Test-EnsureExistPath $RcmWriterXml

# 出力ディレクトリの確保
if (!(Test-Path $OutputDirectoryRoot)) {
    mkdir $OutputDirectoryRoot > $null
}

if (!(Test-Path $OutputDirectory)) {
    mkdir $OutputDirectory > $null
}

# Configファイルのコピー
cp $RcmWriterXml $OutputConfig

# Rcm の実行
Invoke-CriticalCommand "& `"$RcmWriter`" --rcm `"$RcmWriterRcm`" --list `"$OutputConfig`" $RcmWriterAdditionalOptions"

Write-Host "Dumped to $OutputDirectory"
