﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        修理システムを更新するCMAC付き初期化イメージ(*.initimgm)を作成します。

    .DESCRIPTION
        修理システムを更新するCMAC付き初期化イメージ(*.initimgm)を作成します。
#>
[CmdletBinding()]
Param
(
    [string]
    $KeyType = 'K5',

    [string]
    $ConnectionType = 'Manu',

    [string]
    $SignedType = 'Unsigned',

    [string]
    $BootType = 'ManuBoot',

    [string]
    $StorageSize = '32G',

    [string]
    $DeveloperType = 'Repair',

    [string]
    $BuildType = 'Develop',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $CmacKeyName = 'TestWsIssuerCmacKey',

    [string]
    $CmacKeyFile = ""
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../../Modules/Utility"

$AdditionalExtention = ""
if ($KeyType -eq 'K6')
{
    $AdditionalExtention = ".prod"
}

$InitialImageName     = "NX-$KeyType-$ConnectionType-$SignedType-$BootType-$StorageSize-$DeveloperType"
$InitialImagePath     = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/InitialImages/$InitialImageName/$BuildType/$InitialImageName.initimg"
$InitialArchiveName   = "$InitialImageName"
$InitialArchivePath   = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$InitialArchiveName/$BuildType/$InitialArchiveName${AdditionalExtention}.nfa"
$MakeInitialImage     = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/MakeInitialImage.exe"
$MakeCmacInitialImage = "$(Get-NintendoSdkRootPath)/Integrate/Scripts/NX/Manufacturing//Make-CmacInitialImage.ps1"

Write-Output "InitialImageName     : $InitialImageName     "
Write-Output "InitialImagePath     : $InitialImagePath     "
Write-Output "InitialArchiveName   : $InitialArchiveName   "
Write-Output "InitialArchivePath   : $InitialArchivePath   "
Write-Output "MakeInitialImage     : $MakeInitialImage     "
Write-Output "MakeCmacInitialImage : $MakeCmacInitialImage "


trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Test-EnsureExistPath $InitialArchivePath

$InitialImageDirectoryPath = [System.IO.Path]::GetDirectoryName($InitialImagePath)
if (!(Test-Path $InitialImageDirectoryPath)) {
    New-Item $InitialImageDirectoryPath -itemType Directory | Out-Null
}
Invoke-CriticalCommand "& `"$MakeInitialImage`" -i `"$InitialArchivePath`" -o `"$InitialImagePath`""

$AdditionalOption = "-CmacKeyFile $CmacKeyFile"
if([String]::IsNullOrEmpty($CmacKeyFile))
{
    $AdditionalOption = "-CmacKeyName $CmacKeyName"
}

Invoke-CriticalCommand "& `"$MakeCmacInitialImage`" ``
    -BuildType $BuildType ``
    -Platform $Platform ``
    -KeyType $KeyType ``
    -ConnectionType $ConnectionType ``
    -BootType $BootType ``
    -SignedType $SignedType ``
    -StorageSize $StorageSize ``
    $AdditionalOption ``
    -DeveloperType $DeveloperType" 
