<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Create PseudoProdKey Qspi Image

    .DESCRIPTION
        Create PseudoProdKey Qspi Image
#>
[CmdletBinding()]
Param
(
    [string]
    $KeyType = 'K5',

    [string]
    $ConnectionType = 'Manu',

    [string]
    $SignedType = 'Unsigned',

    [string]
    $DeveloperType = 'Repair',

    [string]
    $BuildType = 'Develop',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $Suffix = '',

    [switch]
    $NoEncrypt = $false
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

if($Suffix.Length -ne 0)
{
    Write-Host "  Suffix:         $Suffix"
}

Import-Module "${scriptDirectoryPath}/../../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../../Modules/Utility"

if ($NoEncrypt)
{
    $Suffix = ".raw"
    $EncryptOption = ""
}
else
{
    $EncryptOption = "--encrypt"
}

$MakeSignedSystemPartition = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/MakeSignedSystemPartition.exe"
$NfaName = "RecoveryWriter-K5-Manu-Unsigned-Repair"

if ($KeyType -eq 'K5')
{
    $SignedSystemPartitionName = "${DeveloperType}SSP-$ConnectionType-P2$SignedType"
    if ($SignedType -eq 'Unsigned')
    {
        $Package2Name = "RepairPackage2ForInitialize"
        $Package2Option = "-a $(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/Package2Images/$Package2Name/$BuildType/$Package2Name.package2.img" 
    }
    else
    {
        $Package2Option = "-a $(Get-NintendoSdkRootPath)/Externals/NxSystemImages/Package2Signed/$BuildType/p2repair-initialize.bin"
    }
}
else
{
    $NfaName = "${DeveloperType}SSP-$ConnectionType-P2None-Prod"
    $SignedSystemPartitionName = "${DeveloperType}SSP-$ConnectionType-P2$SignedType-Prod"
    $Package2Option = ""
}

$SignKeyFile       = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/SignedFatImage/Internal.yaml"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$FirmwareArchivePath       = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$NfaName/$BuildType/$NfaName.nfa"
$SignedSystemPartitionPath = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/SystemPartition/$SignedSystemPartitionName/$BuildType/$SignedSystemPartitionName$Suffix.fatimg"

Test-EnsureExistPath $FirmwareArchivePath
Test-EnsureExistPath $MakeSignedSystemPartition
Test-EnsureExistPath $SignKeyFile

# create directory if necessary
$OutputDirectoryPath = [System.IO.Path]::GetDirectoryName($SignedSystemPartitionPath)
if (!(Test-Path $OutputDirectoryPath)) {
    New-Item $OutputDirectoryPath -itemType Directory | Out-Null
}

Write-Output "Exe :$MakeSignedSystemPartition"
Write-Output "In  :$FirmwareArchivePath"
Write-Output "Out :$SignedSystemPartitionPath"
Write-Output "Key :$SignKeyFile"
Write-Output "$Package2Option"
Write-Output "$EncryptOption"

Invoke-Expression "& `"$MakeSignedSystemPartition`" --size 11 --free-space 2900KiB ``
    -i `"$FirmwareArchivePath`" ``
    -o `"$SignedSystemPartitionPath`" ``
    $Package2Option  ``
    --key `"$SignKeyFile`" $EncryptOption"
