﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        修理システムにインストールされているプログラムを実行します。

    .DESCRIPTION
        修理システムにインストールされているプログラムを実行します。
#>
[CmdletBinding()]
Param
(
    [string]
    $Mode = '',

    [string]
    $ServerConfig = 'LocalRepairServerConfig',

    [string]
    $DevicePath = "",

    [string]
    $DoProcessClean = "true",

    [string]
    $AutoStart = '',

    [string]
    $AutoExit = ''
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../../Modules/Runner"

Test-ParameterIsNotNullOrEmpty -Name "Mode" -Value $Mode
Test-ParameterIsNotNullOrEmpty -Name "ServerConfig" -Value $ServerConfig

$BackupRestoreTool = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/BackupRestoreTool.exe"
$BackupRestoreToolConfig = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/RequestToRepairServiceConfig/$ServerConfig.yaml"

Test-EnsureExistPath $BackupRestoreTool
Test-EnsureExistPath $BackupRestoreToolConfig

$DevicePathOption = ""
if(![System.String]::IsNullOrEmpty($DevicePath))
{
    $DevicePathOption = "--usb_device_path $DevicePath"
}

$AutoStartOption = ""
if(![System.String]::IsNullOrEmpty($AutoStart))
{
    $AutoStartOption = "--autostart"
}

$AutoExitOption = ""
if(![System.String]::IsNullOrEmpty($AutoExit))
{
    $AutoExitOption = "--autoexit"
}

Invoke-CriticalCommand "& `"$BackupRestoreTool`" $mode --config `"$BackupRestoreToolConfig`" $DevicePathOption `"$AutoStartOption`" `"$AutoExitOption`""
