﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Write serial number to HostBridge.

    .DESCRIPTION
        Write serial number to HostBridge.
        This script works only when TargetManager can connect to Target.
#>
[CmdletBinding()]
Param
(
    # The host IP address
    [string]
    $HostBridgeAddress,
    
    [switch]
    $WriteName
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/HostBridge"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

$SdevHostBridgeConsolePath = "$(Get-NintendoSdkRootPath)/Externals/HostBridge/tools/HostBridgeController/Resources/Console_2_1_0.exe"
$ControlTargetPath = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/ControlTarget.exe"
$WriteSerialNumberProgram = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/WriteSerialNumberToHostBridge.exe"

Test-ParameterIsNotNullOrEmpty -Name "HostBridgeAddress" -Value $HostBridgeAddress

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

# Serial number を取得
$SerialNumber = Get-SerialNumber -HostBridgeAddress $HostBridgeAddress

if ([String]::IsNullOrEmpty($SerialNumber))
{
    Write-Host "Write serial number to the HostBridge."

    Invoke-Expression "& `"$ControlTargetPath`" power-on --target $HostBridgeAddress"

    Write-Host "Wait for booting the Target."
    Wait-Seconds 30

    # Serial number が HostBridge に書き込まれていない場合は書き込む
    if($WriteName)
    {
        Write-Host "Write serial and name."
        Invoke-Expression "& `"$WriteSerialNumberProgram`" --target $HostBridgeAddress --write-name --verbose"
    }
    else
    {
        Write-Host "Write serial."
        Invoke-Expression "& `"$WriteSerialNumberProgram`" --target $HostBridgeAddress --verbose"
    }
}
