﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Write Package2 by QSPI boot

    .DESCRIPTION
        Write Package2 by QSPI boot.
#>
[CmdletBinding()]
Param
(
    # The host IP address pattern as RegularExpression
    [Parameter(Mandatory=$true)]
    [string]
    $AddressPattern = '.*',
    
    [string]
    $BuildType = 'Develop',

    [string]
    $Platform = 'NX-NXFP2-a32'
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/HostBridge"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

$InvokeQspiBoot = "$(Get-NintendoSdkRootPath)/Integrate/Scripts/NX/Recovery/Invoke-QspiMode.ps1"
$QspiBootImage = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/QspiBootImages/Package2Writer/$BuildType/Package2Writer.qspi.img"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Test-EnsureExistPath $QspiBootImage
Invoke-CriticalCommand "& `"$InvokeQspiBoot`" -AddressPattern `"$AddressPattern`" -QspiBootImage `"$QspiBootImage`""
