﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Restart HostBridge

    .DESCRIPTION
        Restart HostBridge.
#>
[CmdletBinding()]
Param
(
    # The host IP address pattern as RegularExpression
    [Parameter(Mandatory=$true)]
    [string]
    $AddressPattern = '.*',
        
    [Switch]
    $WaitBoot
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/HostBridge"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$TargetAddress = Get-SigleTargetAddress -AddressPattern $AddressPattern
Restart-HostBridge $TargetAddress

if($WaitBoot)
{
    Start-Sleep -s 1
    Wait-HostBridge $TargetAddress
}
Start-SaveHostBridgeLog -HostBridgeAddress $TargetAddress -rebooted
