<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Convert text format key to binary format.

    .DESCRIPTION
        Convert text format key to binary format.
#>
[CmdletBinding()]
Param
(
    [string]
    $Path = '',

    [string]
    $Out = ''
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../../Modules/Utility"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Test-EnsureExistPath $Path

$data = Get-Content $Path

$list = New-Object System.Collections.Generic.List[byte]
$re = New-Object regex("(..)")
$match = $re.Matches($data)
$match | ForEach-Object { $list.Add([System.Convert]::ToByte($_.Value, 16)) }
[System.IO.File]::WriteAllBytes($Out, $list)