<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Initialize sdev mp by system updater.

    .DESCRIPTION
        Initialize sdev mp by system updater.
#>
[CmdletBinding()]
Param
(
    [string]
    $BuildType = 'Release',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $KeyType = "K5",

    [string]
    $BootType = "ManuBoot",

    [string]
    $SignedType = "Signed",

    [string]
    $StorageSize = "64G",

    [string]
    $DeveloperType = "ManufacturingTestWithNvdbgsvc",

    [string]
    $ConfigName = "TestWsIssuerServerConfig",

    [string]
    $CalImageFile = "",

    [string]
    $FirstInitializeType = "ManuRcm",   # Qspi or DevRcm or ManuRcm

    [string]
    $AddressPattern = $env:TARGET_ADDRESS_PATTERN,  # only: FirstInitializeType == Qspi

    [string]
    $Timeout = "180"

)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if($FirstInitializeType -eq "Qspi" -and [String]::IsNullOrEmpty($AddressPattern))
{
    throw "Requires AddressPattern parameter when FirstInitializeType is Qspi"
}
if([String]::IsNullOrEmpty($AddressPattern))
{
    $AddressPattern = "169.*"
}

$CalImageOption = ""
if(($CalImageFile -ne "") -and (Test-Path $CalImageFile))
{
    $CalImageOption = "-CalImageFile `"$CalImageFile`""
}

$TimeoutOption = ""
if($Timeout -ne "180")
{
    $TimeoutOption = "-Timeout `"$Timeout`""
}

$ManufactureFinalizeWithAuth = "$($scriptDirectoryPath)/Manufacture-FinalizeWithAuth.ps1"

Invoke-CriticalCommand "& `"$ManufactureFinalizeWithAuth`" -BuildType $BuildType -Platform $Platform -KeyType $KeyType -BootType $BootType -SignedType $SignedType -StorageSize $StorageSize -DeveloperType $DeveloperType -ConfigName $ConfigName -FirstInitializeType $FirstInitializeType -AddressPattern $AddressPattern $CalImageOption $TimeoutOption"
