<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Initialize prod mp by system updater.

    .DESCRIPTION
        Initialize prod mp by system updater.
#>
[CmdletBinding()]
Param
(
    [string]
    $BuildType = 'Release',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $KeyType = "M2",

    [string]
    $BootType = "ManuBoot",

    [string]
    $SignedType = "Signed",

    [string]
    $StorageSize = "32G",

    [string]
    $DeveloperType = "PreFinalize",

    [string]
    $ConfigName = "TestIowaWsIssuerServerConfig",

    [string]
    $FirstInitializeType = "Skip",   # Qspi or DevRcm or ManuRcm or Skip

    [string]
    $AddressPattern = "169.*",  # only: FirstInitializeType == Qspi

    [Int]
    $DetectTargetRetryCount = 5
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$ManufactureFinalizeWithAuth = "$($scriptDirectoryPath)/Manufacture-FinalizeWithAuth.ps1"

Invoke-Expression "& `"$ManufactureFinalizeWithAuth`" -BuildType $BuildType -Platform $Platform -KeyType $KeyType -BootType $BootType -SignedType $SignedType -StorageSize $StorageSize -DeveloperType $DeveloperType -ConfigName $ConfigName -FirstInitializeType $FirstInitializeType -AddressPattern $AddressPattern "
