<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Initialize edev by system updater.

    .DESCRIPTION
        Initialize edev by system updater.
#>
[CmdletBinding()]
Param
(
    [string]
    $BuildType = 'Release',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $KeyType = "K6",

    [string]
    $BootType = "ManuBoot",

    [string]
    $SignedType = "Signed",

    [string]
    $StorageSize = "32G",

    [string]
    $ConnectionType = "Manu",

    [string]
    $DeveloperType = "ManufacturingTest",

    [string]
    $ConfigName = "LocalWsIssuerServerConfig",

    [string]
    $FirstInitializeType = "Qspi",   # Qspi or DevRcm or ManuRcm

    [string]
    $AddressPattern = "169.*",  # only: FirstInitializeType == Qspi

    [string]
    $CalImageFile = "",

    [string]
    $DevicePath = "",

    [bool]
    $DoProcessClean = $true,

    [string]
    $Timeout = "180"
)

$QspiConnectionType = "Manu"

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

# Names
$ImageName                = "NX-$KeyType-$ConnectionType-$SignedType-$BootType-$StorageSize-$DeveloperType"

# File names
$RunSystemInitializerManu = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/RunSystemInitializerManu.exe"
$ImagePath                = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/NX-NXFP2-a64/InitialImages/$ImageName/$BuildType/$ImageName.initimgm"
# $InitializerPath          = "$(Get-NintendoSdkRootPath)/Programs/Chris/Outputs/NX-NXFP2-a64/TargetTools/SystemInitializerManu/$BuildType/SystemInitializerManu.nca"
$TemporaryDirectory       = "$(Get-NintendoSdkRootPath)/Integrate/Outputs"
$ConfigPath               = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/RequestToWsIssuerConfig/$ConfigName.yaml"

# Test existing files
Test-EnsureExistPath $RunSystemInitializerManu
Test-EnsureExistPath $ImagePath
# Test-EnsureExistPath $InitializerPath
Test-EnsureExistPath $ConfigPath

if($DoProcessClean)
{
    Stop-ProcessesForSystemInitialize
}
else
{
    Write-Host "Skip Process Cleaning."
}

if (!(Test-Path $TemporaryDirectory)) {
    New-Item $TemporaryDirectory -itemType Directory | Out-Null
}

$DevicePathOption = ""
if($DevicePath)
{
    $DevicePathOption = "--usb_device_path $DevicePath"
}

$CalImageOption = ""
if(($CalImageFile -ne "") -and (Test-Path $CalImageFile))
{
    Write-Host "Write Cal Image."
    $CalImageOption = "--cal-image `"$CalImageFile`""
}

function Write-ByManuRcm()
{
    $UsbRecoveryImageWriter = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/UsbRecoveryImageWriter/UsbRecoveryImageWriter.exe"
    $UsbRecoveryImageWriterRcm = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/UsbRecoveryImageWriter/UsbRecoveryImageWriter.Signed.$KeyType.rcm"
    $RecoveryWriterName = "RecoveryWriter-$KeyType-$QspiConnectionType-$SignedType"
    $RecoveryWriter = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/QspiBootImages/$RecoveryWriterName/$BuildType/$RecoveryWriterName.qspi.img"

    Test-EnsureExistPath $UsbRecoveryImageWriterRcm
    Test-EnsureExistPath $RecoveryWriter

    Invoke-CriticalCommand "& `"$UsbRecoveryImageWriter`" --rcm $UsbRecoveryImageWriterRcm --image $RecoveryWriter"

    Wait-Seconds 10
}

if($FirstInitializeType -eq 'Qspi') {
    $WriteRecovery    = "$(Get-NintendoSdkRootPath)/Integrate/Scripts/NX/Recovery/Write-RecoverySystem.ps1"
    $RecoveryWriterName = "RecoveryWriter-$KeyType-$QspiConnectionType-$SignedType"
    $RecoveryWriter = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/QspiBootImages/$RecoveryWriterName/$BuildType/$RecoveryWriterName.qspi.img"

    Test-EnsureExistPath $RecoveryWriter

    # Write recovery system.
    Invoke-CriticalCommand "& `"$WriteRecovery`" -AddressPattern $AddressPattern -BuildType $BuildType -Platform $Platform -RecoveryWriter $RecoveryWriter"

    Wait-Seconds 10
}
elseif($FirstInitializeType -eq 'ManuRcm') {
    Write-ByManuRcm
}
elseif($FirstInitializeType -eq 'BreakBctFrcm'){
    $BreakBctScript = "$($scriptDirectoryPath)/Manufacture-BreakBct-$KeyType.bat"
    Test-EnsureExistPath $BreakBctScript

    Invoke-CriticalCommand "& `"$BreakBctScript`" -BuildType $BuildType "

    Write-ByManuRcm
}
elseif($FirstInitializeType -eq 'DevRcm'){
}
else
{
}

# Initialize
Invoke-Expression "& `"$RunSystemInitializerManu`" $DevicePathOption --verbose --image $ImagePath --initializer 0100000000002103 --tmpdir $TemporaryDirectory --config $ConfigPath --timeout $Timeout `"--`" --enable-overwriting-production-info --enable-erase-emmc $CalImageOption"
