<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Copy Product Images To Appropriate Path

    .DESCRIPTION
        Copy Product Images To Appropriate Path
#>
[CmdletBinding()]
Param
(
    [string]
    $KeyType = 'K6',
    
    [string]
    $ConnectionType = 'Manu',
    
    [string]
    $SignedType = 'Signed',
    
    [string]
    $BootType = 'ManuBoot',
    
    [string]
    $StorageSize = '32G',
    
    [string]
    $BuildType = 'Release',
    
    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $ChangeKeyZipPath = ""
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../Modules/Localize"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Test-EnsureExistPath $ChangeKeyZipPath

$UnzipDirectory       = "$(Get-NintendoSdkRootPath)/ManuUnzip"
if (Test-Path $UnzipDirectory) {
    Remove-Item $UnzipDirectory -Recurse
}
Expand-Zip $ChangeKeyZipPath "$UnzipDirectory"

$InputsPath = "$UnzipDirectory/ManufacturingProd-ChangeKey/Programs/Eris/Outputs/$Platform"
$OutputsPath = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform"

$QspiBootImageName = "RecoveryWriter-$KeyType-$ConnectionType-$SignedType"
$QspiBootImagePath = "SystemImages/QspiBootImages/$QspiBootImageName"
$BreakBctImageName = "BreakBct.$KeyType"
$BreakBctImagePath = "InitialImages/BreakBct"
$PreFinalizeImageName = "NX-$KeyType-$ConnectionType-$SignedType-$BootType-$StorageSize-PreFinalize"
$PreFinalizeImagePath = "InitialImages/$PreFinalizeImageName"
$InitializeImageName = "NX-$KeyType-$ConnectionType-$SignedType-$BootType-$StorageSize-ManufacturingTest"
$InitializeImagePath = "InitialImages/$InitializeImageName"

if (!(Test-Path "$OutputsPath/$QspiBootImagePath")) {
    New-Item "$OutputsPath/$QspiBootImagePath" -itemType Directory | Out-Null
}

if (!(Test-Path "$OutputsPath/$BreakBctImagePath")) {
    New-Item "$OutputsPath/$BreakBctImagePath" -itemType Directory | Out-Null
}

if (!(Test-Path "$OutputsPath/$PreFinalizeImagePath")) {
    New-Item "$OutputsPath/$PreFinalizeImagePath" -itemType Directory | Out-Null
}

if (!(Test-Path "$OutputsPath/$InitializeImagePath")) {
    New-Item "$OutputsPath/$InitializeImagePath" -itemType Directory | Out-Null
}

Copy-Item "$InputsPath/$QspiBootImagePath/$BuildType" "$OutputsPath/$QspiBootImagePath" -Recurse -Force
Copy-Item "$InputsPath/$BreakBctImagePath/$BuildType" "$OutputsPath/$BreakBctImagePath" -Recurse -Force
Copy-Item "$InputsPath/$PreFinalizeImagePath/$BuildType" "$OutputsPath/$PreFinalizeImagePath" -Recurse -Force
Copy-Item "$InputsPath/$InitializeImagePath/$BuildType" "$OutputsPath/$InitializeImagePath" -Recurse -Force

Remove-Item $UnzipDirectory -Recurse
