<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Initialize sdev by system updater.

    .DESCRIPTION
        Initialize sdev by system updater.
#>
[CmdletBinding()]
Param
(
    # The host IP address pattern as RegularExpression
    [string]
    $AddressPattern,
    
    [string]
    $BuildType = 'Develop',
    
    [string]
    $Platform = 'NX-NXFP2-a64',
    
    [string]
    $KeyType = 'Auto' # K1, K2, Auto
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/HostBridge"
Import-Module "${scriptDirectoryPath}/../../Modules/Runner"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../Modules/InitializeTarget"

$InitializeSdev    = "$($scriptDirectoryPath)/Initialize-Sdev-Raw.ps1"

$KeyType =        'Auto'
$ConnectionType = 'Hb'
$BootType =       'Nand'
$SignedType =     'Unsigned'
$StorageSize =    '64G' 
$DeveloperType =  'Internal'

if($KeyType -eq 'Auto')
{
    # Get the address of the HostBridge
    $TargetAddress = Get-SigleTargetAddress -AddressPattern $AddressPattern
     
    $KeyType = Get-TargetFusedKeyType $TargetAddress
}

Invoke-Expression "& `"$InitializeSdev`" -AddressPattern $AddressPattern -BuildType $BuildType -Platform $Platform -KeyType $KeyType -ConnectionType $ConnectionType -BootType $BootType -SignedType $SignedType -StorageSize $StorageSize -DeveloperType $DeveloperType"
