<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Initialize sdev by system updater.

    .DESCRIPTION
        Initialize sdev by system updater.
#>
[CmdletBinding()]
Param
(
    # The host IP address pattern as RegularExpression
    [string]
    $AddressPattern,
    
    [string]
    $BuildType = 'Develop',
    
    [string]
    $Platform = 'NX-NXFP2-a64',
    
    [switch]
    $SkipHostBridgeUpdate = $false,

    [switch]
    $SkipStopTargetManager = $false,

    [switch]
    $SkipStopProcessesForCi = $false
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

$InitializeSdevRaw    = "$($scriptDirectoryPath)/Initialize-Sdev-Full-Raw.ps1"

$KeyType =        'Auto'
$ConnectionType = 'Hb'
$BootType =       'List'
$SignedType =     'Unsigned'
$StorageSize =    '64G' 
$DeveloperType =  'Internal'

Invoke-Expression "& `"$InitializeSdevRaw`" -AddressPattern $AddressPattern -BuildType $BuildType -Platform $Platform -KeyType $KeyType -ConnectionType $ConnectionType -BootType $BootType -SignedType $SignedType -StorageSize $StorageSize -DeveloperType $DeveloperType -SkipHostBridgeUpdate:`$$SkipHostBridgeUpdate -SkipStopTargetManager:`$$SkipStopTargetManager -SkipStopProcessesForCi:`$$SkipStopProcessesForCi"
